/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.link;

import com.atlassian.confluence.api.model.link.LinkType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Link {
    @JsonProperty
    private final LinkType type;
    @JsonProperty
    private final String path;

    @JsonCreator
    public Link(@JsonProperty(value="type") LinkType type, @JsonProperty(value="path") String path) {
        this.type = type;
        this.path = path;
    }

    private Link(LinkBuilder linkBuilder) {
        this.path = linkBuilder.path;
        this.type = linkBuilder.type;
    }

    public LinkType getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.path);
    }

    public String toString() {
        return String.valueOf(this.type) + "=" + this.path;
    }

    public static LinkBuilder builder() {
        return new LinkBuilder();
    }

    public static class LinkBuilder {
        private String path;
        private LinkType type;

        private LinkBuilder() {
        }

        public LinkBuilder path(String path) {
            this.path = path;
            return this;
        }

        public LinkBuilder type(LinkType linkType) {
            this.type = linkType;
            return this;
        }

        public Link build() {
            return new Link(this);
        }
    }
}

