/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.confluence.api.model.content.ContentType;
import java.util.HashMap;

public enum CursorType {
    SPACE("space"),
    CONTENT("content"),
    BLOG_POST("blogpost"),
    COMMENT("comment"),
    SYNC("sync"),
    ATTACHMENT("attachment");

    private static final HashMap<String, CursorType> typeToEnumMapper;
    private final String type;

    public static CursorType getCursorType(String type) {
        return typeToEnumMapper.get(type);
    }

    public static CursorType getCursorType(ContentType contentType) {
        CursorType cursorType = CursorType.getCursorType(contentType.getType());
        if (cursorType != null) {
            return cursorType;
        }
        throw new IllegalArgumentException("Unsupported cursor type for content type: " + String.valueOf(contentType));
    }

    private CursorType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    static {
        typeToEnumMapper = new HashMap();
        for (CursorType cursorType : CursorType.values()) {
            typeToEnumMapper.put(cursorType.getType(), cursorType);
        }
        typeToEnumMapper.put(ContentType.PAGE.getType(), CONTENT);
    }
}

