/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.pagination.SpaceFilterAwarePageResponse;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@RestEnrichable
public class SpaceFilterAwarePageResponseImpl<T>
implements SpaceFilterAwarePageResponse<T> {
    private boolean hasMore;
    private List<T> list;
    private PageRequest request;
    private Cursor nextCursor;
    private Cursor prevCursor;
    private Optional<Long> totalCount;
    private Optional<List<T>> blockedList;

    protected SpaceFilterAwarePageResponseImpl(Builder<T, ?> builder) {
        this.hasMore = ((Builder)builder).hasMore;
        this.list = ((Builder)builder).list;
        this.request = ((Builder)builder).request;
        this.nextCursor = ((Builder)builder).nextCursor;
        this.prevCursor = ((Builder)builder).prevCursor;
        this.totalCount = ((Builder)builder).totalCount;
        this.blockedList = ((Builder)builder).blockedList;
    }

    @Override
    public Optional<List<T>> getBlockedList() {
        return this.blockedList;
    }

    @Override
    public PageRequest getPageRequest() {
        return this.request;
    }

    @Override
    public Optional<Long> getTotalCount() {
        return this.totalCount;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> getResults() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public Cursor getNextCursor() {
        return this.nextCursor;
    }

    @Override
    public Cursor getPrevCursor() {
        return this.prevCursor;
    }

    public String toString() {
        return "SpaceFilterAwarePageResponseImpl{pageRequest=" + String.valueOf(this.request) + ", wrappedList=" + String.valueOf(this.list) + ", hasMore=" + this.hasMore + ", nextCursor=" + String.valueOf(this.nextCursor) + ", prevCursor=" + String.valueOf(this.prevCursor) + "}";
    }

    public static <T> Builder<T, ? extends Builder> from(PageResponse<T> pageResponse, List<T> blockedList, @Nullable Iterable<T> list) {
        Builder builder = new Builder();
        builder.addAll(list == null ? pageResponse.getResults() : list);
        builder.request = pageResponse.getPageRequest();
        builder.nextCursor = pageResponse.getNextCursor();
        builder.prevCursor = pageResponse.getPrevCursor();
        builder.hasMore = pageResponse.hasMore();
        builder.totalCount = pageResponse.getTotalCount();
        builder.blockedList = blockedList == null ? Optional.empty() : Optional.of(blockedList);
        return builder;
    }

    public static class Builder<E, B> {
        private boolean hasMore;
        private List<E> list = new ArrayList();
        private PageRequest request;
        private Cursor nextCursor;
        private Cursor prevCursor;
        private Optional<Long> totalCount = Optional.empty();
        private Optional<List<E>> blockedList = Optional.empty();

        public SpaceFilterAwarePageResponseImpl<E> build() {
            return new SpaceFilterAwarePageResponseImpl(this);
        }

        public B add(E add) {
            this.list.add(add);
            return (B)this;
        }

        public B addAll(Iterable<E> toAdd) {
            toAdd.forEach(this.list::add);
            return (B)this;
        }

        public B pageRequest(PageRequest request) {
            this.request = request;
            return (B)this;
        }

        public B pageRequest(LimitedRequest limitedRequest) {
            this.request = new SimplePageRequest(limitedRequest);
            return (B)this;
        }

        public B hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return (B)this;
        }

        public B nextCursor(Cursor nextCursor) {
            this.nextCursor = nextCursor;
            return (B)this;
        }

        public B prevCursor(Cursor prevCursor) {
            this.prevCursor = prevCursor;
            return (B)this;
        }

        public B totalCount(Optional<Long> totalCount) {
            this.totalCount = totalCount;
            return (B)this;
        }

        public B blockedList(Optional<List<E>> blockedList) {
            this.blockedList = blockedList;
            return (B)this;
        }
    }
}

