/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.people.UserStatus;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.RestEnrichableProperty;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class KnownUser
extends User
implements NavigationAware {
    @JsonProperty
    @Schema(example="user@email.com")
    private final String email;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=String.class)
    @JsonProperty
    @Schema(example="Dec 06, 2024 14:51")
    private final Reference<String> lastLogin;
    @JsonIgnore
    @RestEnrichableProperty
    private final String type = "known";
    @JsonDeserialize(as=ExpandedReference.class, contentAs=UserStatus.class)
    @JsonProperty
    private final Reference<UserStatus> status;

    @JsonCreator
    public KnownUser(@JsonProperty(value="profilePicture") Reference<Icon> profilePicture, @JsonProperty(value="username") String username, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="userKey") String userKey) {
        super(profilePicture, username, displayName, userKey);
        this.status = Reference.collapsed(UserStatus.class);
        this.email = null;
        this.lastLogin = null;
    }

    public KnownUser(Icon profilePicture, @JsonProperty(value="username") String username, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="userKey") String userKey) {
        super(profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class), username, displayName, userKey);
        this.status = Reference.collapsed(UserStatus.class);
        this.email = null;
        this.lastLogin = null;
    }

    @Deprecated
    public KnownUser(Icon profilePicture, String username, String displayName, UserKey userKey) {
        super(username, displayName, userKey, profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class));
        this.status = Reference.collapsed(UserStatus.class);
        this.email = null;
        this.lastLogin = null;
    }

    @Deprecated
    public KnownUser(Icon profilePicture, String username, String displayName) {
        this(profilePicture, username, displayName, (UserKey)null);
    }

    private KnownUser(Builder builder) {
        super(Objects.requireNonNull(builder.username), Objects.requireNonNull(builder.displayName), Objects.requireNonNull(builder.userKey), builder.profilePicture);
        this.status = builder.status != null ? builder.status : Reference.collapsed(UserStatus.class);
        this.email = builder.email;
        this.lastLogin = builder.lastLoginDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnownUser knownUser = (KnownUser)o;
        return Objects.equals(this.email, knownUser.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.email, "known");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return this.optionalUserKey().map(key -> navigationService.createNavigation().user((UserKey)key)).orElse(null);
    }

    @JsonIgnore
    public Reference<UserStatus> getStatusRef() {
        return this.status;
    }

    public String getEmail() {
        return this.email;
    }

    public Reference<String> getLastLoginRef() {
        return this.lastLogin;
    }

    public static class Builder {
        private Reference<Icon> profilePicture;
        private String username;
        private UserKey userKey;
        private String displayName;
        private String email;
        private Reference<String> lastLoginDate;
        private Reference<UserStatus> status;

        public Builder profilePicture(Icon profilePicture) {
            this.profilePicture = profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class);
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder userKey(UserKey userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder userKey(String userKey) {
            this.userKey = new UserKey(userKey);
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder status(UserStatus status) {
            this.status = Reference.to(status);
            return this;
        }

        public Builder lastLogin(String lastLoginDate) {
            this.lastLoginDate = lastLoginDate != null ? Reference.to(lastLoginDate) : Reference.collapsed(String.class);
            return this;
        }

        public KnownUser build() {
            return new KnownUser(this);
        }
    }
}

