/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.serialization.SwaggerEnrichExpandable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichLinks;
import com.atlassian.graphql.annotations.GraphQLTypeName;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=User.class, name="user"), @JsonSubTypes.Type(value=UnknownUser.class, name="unknown"), @JsonSubTypes.Type(value=KnownUser.class, name="known"), @JsonSubTypes.Type(value=Anonymous.class, name="anonymous")})
@JsonIgnoreProperties(ignoreUnknown=true)
@GraphQLTypeName(value="User")
@SwaggerEnrichLinks
@SwaggerEnrichExpandable
public abstract class Person
implements Subject {
    protected static final String KNOWN_USER_TYPE = "known";
    public static final String ANONYMOUS_USER_TYPE = "anonymous";
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Icon.class)
    @JsonProperty
    @Schema
    private final Reference<Icon> profilePicture;
    @JsonProperty
    @Schema(example="Joe Smith")
    private final String displayName;

    protected Person(Reference<Icon> profilePicture, String displayName) {
        this.profilePicture = profilePicture != null ? profilePicture : Reference.collapsed(Icon.class);
        this.displayName = displayName;
    }

    protected Person(Icon profilePicture, String displayName) {
        this.profilePicture = profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class);
        this.displayName = displayName;
    }

    protected Person(PersonBuilder personBuilder) {
        this.profilePicture = personBuilder.profilePicture;
        this.displayName = personBuilder.displayName;
    }

    @Deprecated
    protected Person(Icon profilePicture) {
        this(profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class), "");
    }

    public @Nullable Icon getProfilePicture() {
        return this.profilePicture != null && this.profilePicture.existsAndExpanded() ? this.profilePicture.get() : null;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonIgnore
    public abstract Optional<String> optionalUsername();

    @JsonIgnore
    public abstract Optional<UserKey> optionalUserKey();

    @Override
    @JsonIgnore
    public SubjectType getSubjectType() {
        return SubjectType.USER;
    }

    public static abstract class PersonBuilder<T extends PersonBuilder<T>> {
        private String displayName;
        protected Reference<Icon> profilePicture;

        public T displayName(String displayName) {
            this.displayName = displayName;
            return this.self();
        }

        public T profilePicture(Icon profilePicture) {
            this.profilePicture = profilePicture != null ? Reference.to(profilePicture) : Reference.collapsed(Icon.class);
            return this.self();
        }

        protected abstract T self();

        public abstract Person build();
    }
}

