/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class ContentRestrictionsPageResponse
extends PageResponseImpl<ContentRestriction>
implements NavigationAware {
    @JsonProperty
    private final String restrictionsHash;
    @JsonProperty
    private final Map<LinkType, Link> links;
    @JsonIgnore
    private final ContentId contentId;

    @JsonCreator
    private ContentRestrictionsPageResponse() {
        this(ContentRestrictionsPageResponse.builder());
    }

    private ContentRestrictionsPageResponse(ContentRestrictionPageResponseBuilder builder) {
        super(builder);
        this.restrictionsHash = builder.restrictionsHash;
        this.links = Collections.unmodifiableMap(builder.links);
        this.contentId = builder.contentId;
    }

    public Map<LinkType, Link> getLinks() {
        return this.links;
    }

    public static ContentRestrictionPageResponseBuilder builder() {
        return new ContentRestrictionPageResponseBuilder();
    }

    public String getRestrictionsHash() {
        return this.restrictionsHash;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().experimental().content(ContentSelector.builder().id(this.contentId).build()).restrictions();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentRestrictionsPageResponse that = (ContentRestrictionsPageResponse)o;
        return Objects.equals(this.restrictionsHash, that.restrictionsHash) && Objects.equals(this.links, that.links) && Objects.equals(this.contentId, that.contentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.restrictionsHash, this.links, this.contentId);
    }

    public static class ContentRestrictionPageResponseBuilder
    extends PageResponseImpl.Builder<ContentRestriction, ContentRestrictionPageResponseBuilder> {
        private ContentId contentId = ContentId.UNSET;
        private String restrictionsHash = "";
        private final Map<LinkType, Link> links = new HashMap<LinkType, Link>();

        private ContentRestrictionPageResponseBuilder() {
        }

        public ContentRestrictionsPageResponse build() {
            return new ContentRestrictionsPageResponse(this);
        }

        public ContentRestrictionPageResponseBuilder withContentId(ContentId contentId) {
            if (contentId != null) {
                this.contentId = contentId;
            }
            return this;
        }

        public ContentRestrictionPageResponseBuilder withRestrictionsHash(@Nullable String restrictionsHash) {
            this.restrictionsHash = restrictionsHash == null ? "" : restrictionsHash;
            return this;
        }

        public ContentRestrictionPageResponseBuilder addLink(Link link) {
            this.links.put(link.getType(), link);
            return this;
        }

        public ContentRestrictionPageResponseBuilder addLink(LinkType type, String path) {
            return this.addLink(new Link(type, path));
        }
    }
}

