/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@RestEnrichable
@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class SpacePermissionsForSubject {
    @JsonProperty
    private String userKey;
    @JsonProperty
    private String groupName;
    @JsonProperty(value="operations")
    private final Set<OperationDescription> operations = new HashSet<OperationDescription>();

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Set<OperationDescription> getOperations() {
        return Collections.unmodifiableSet(this.operations);
    }

    public void setOperations(Collection<OperationDescription> operations) {
        this.operations.addAll(operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpacePermissionsForSubject that = (SpacePermissionsForSubject)o;
        return Objects.equals(this.userKey, that.userKey) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.groupName, this.operations);
    }
}

