/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.retention;

import com.atlassian.confluence.api.model.retention.AgeUnit;
import com.atlassian.confluence.api.model.retention.RetentionRuleValidator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RetentionRule {
    @JsonProperty
    @Schema(example="365")
    private Integer maxAge;
    @JsonProperty
    @Schema
    private AgeUnit ageUnit;
    @JsonProperty
    @Schema(example="10")
    private Integer maxNumberOfVersions;
    @JsonProperty
    @Schema(example="true")
    private boolean keepAll = true;

    @JsonCreator
    public RetentionRule(@JsonProperty(value="maxAge") Integer maxAge, @JsonProperty(value="ageUnit") AgeUnit ageUnit, @JsonProperty(value="maxNumberOfVersions") Integer maxNumberOfVersions, @JsonProperty(value="keepAll") boolean keepAll) {
        this.maxAge = maxAge;
        this.ageUnit = ageUnit;
        this.maxNumberOfVersions = maxNumberOfVersions;
        this.keepAll = keepAll;
    }

    public RetentionRule() {
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public AgeUnit getAgeUnit() {
        return this.ageUnit;
    }

    public void setAgeUnit(AgeUnit ageUnit) {
        this.ageUnit = ageUnit;
    }

    public Integer getMaxNumberOfVersions() {
        return this.maxNumberOfVersions;
    }

    public void setMaxNumberOfVersions(Integer maxNumberOfVersions) {
        this.maxNumberOfVersions = maxNumberOfVersions;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public void setKeepAll(boolean keepAll) {
        this.keepAll = keepAll;
    }

    public boolean hasVersionLimit() {
        return this.maxNumberOfVersions != null;
    }

    public boolean hasAgeLimit() {
        return this.maxAge != null && this.ageUnit != null;
    }

    public List<String> validate() {
        ArrayList<String> validations = new ArrayList<String>();
        if (!RetentionRuleValidator.isValidMaxAge(this.maxAge).booleanValue()) {
            validations.add(String.format("maxAge should be between than %s and %s", RetentionRuleValidator.MAX_AGE_LOWER_LIMIT, RetentionRuleValidator.MAX_AGE_UPPER_LIMIT));
        }
        if (!RetentionRuleValidator.isValidMaxNumber(this.maxNumberOfVersions).booleanValue()) {
            validations.add(String.format("maxNumberOfVersions should be between %s and %s", RetentionRuleValidator.MAX_NUMBER_LOWER_LIMIT, RetentionRuleValidator.MAX_NUMBER_UPPER_LIMIT));
        }
        if (!RetentionRuleValidator.isValidAgeUnit(this.ageUnit, this.maxAge).booleanValue()) {
            validations.add("ageUnit of DAY, MONTH or YEAR should be provided when maxAge specified");
        }
        if (this.getKeepAll() && (this.getMaxAge() != null || this.getMaxNumberOfVersions() != null)) {
            validations.add("maxAge and maxNumberOfVersions should be null when keepAll is true");
        }
        return validations;
    }

    public LocalDate calculateMaxDate(LocalDate now) {
        return now.minus(this.maxAge.intValue(), ChronoUnit.valueOf(this.ageUnit.name()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof RetentionRule)) {
            return false;
        }
        RetentionRule retentionRule = (RetentionRule)other;
        return Objects.equals(retentionRule.maxAge, this.maxAge) && Objects.equals(retentionRule.ageUnit, this.ageUnit) && Objects.equals(retentionRule.maxNumberOfVersions, this.maxNumberOfVersions) && Objects.equals(retentionRule.getKeepAll(), this.keepAll);
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.ageUnit, this.maxNumberOfVersions, this.keepAll);
    }

    public String toString() {
        return "RetentionRule{maxAge=" + this.maxAge + ", ageUnit=" + String.valueOf(this.ageUnit) + ", maxNumberOfVersions=" + this.maxNumberOfVersions + ", keepAll=" + this.keepAll + "}";
    }

    public static RetentionRuleBuilder builder() {
        return new RetentionRuleBuilder();
    }

    public static class RetentionRuleBuilder {
        private Integer maxAge;
        private AgeUnit ageUnit;
        private Integer maxNumberOfVersions;
        private boolean keepAll;

        public RetentionRuleBuilder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public RetentionRuleBuilder ageUnit(AgeUnit ageUnit) {
            this.ageUnit = ageUnit;
            return this;
        }

        public RetentionRuleBuilder maxNumberOfVersions(Integer maxNumberOfVersions) {
            this.maxNumberOfVersions = maxNumberOfVersions;
            return this;
        }

        public RetentionRuleBuilder keepAll(boolean keepAll) {
            this.keepAll = keepAll;
            return this;
        }

        public RetentionRule build() {
            return new RetentionRule(this.maxAge, this.ageUnit, this.maxNumberOfVersions, this.keepAll);
        }
    }
}

