/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.retention;

import com.atlassian.confluence.api.model.retention.AgeUnit;
import com.atlassian.confluence.api.model.retention.RetentionRuleValidator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrashRetentionRule {
    @JsonProperty
    @Schema(example="365")
    private Integer maxDeletedAge;
    @JsonProperty
    @Schema
    private AgeUnit deletedAgeUnit;
    @JsonProperty
    @Schema(example="true")
    private boolean keepAll = true;

    @JsonCreator
    public TrashRetentionRule(@JsonProperty(value="maxDeletedAge") Integer maxDeletedAge, @JsonProperty(value="deletedAgeUnit") AgeUnit deletedAgeUnit, @JsonProperty(value="keepAll") boolean keepAll) {
        this.maxDeletedAge = maxDeletedAge;
        this.deletedAgeUnit = deletedAgeUnit;
        this.keepAll = keepAll;
    }

    public TrashRetentionRule() {
    }

    public TrashRetentionRule(int maxDeletedAge, AgeUnit ageUnit) {
        this.keepAll = false;
        this.maxDeletedAge = maxDeletedAge;
        this.deletedAgeUnit = ageUnit;
    }

    public Integer getMaxDeletedAge() {
        return this.maxDeletedAge;
    }

    public void setMaxDeletedAge(Integer maxDeletedAge) {
        this.maxDeletedAge = maxDeletedAge;
    }

    public AgeUnit getDeletedAgeUnit() {
        return this.deletedAgeUnit;
    }

    public void setDeletedAgeUnit(AgeUnit deletedAgeUnit) {
        this.deletedAgeUnit = deletedAgeUnit;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public void setKeepAll(boolean keepAll) {
        this.keepAll = keepAll;
    }

    public boolean hasDeletedAgeLimit() {
        return this.maxDeletedAge != null && this.deletedAgeUnit != null;
    }

    public List<String> validate() {
        ArrayList<String> validations = new ArrayList<String>();
        if (!RetentionRuleValidator.isValidMaxAge(this.maxDeletedAge).booleanValue()) {
            validations.add(String.format("maxDeletedAge should be between than %s and %s", RetentionRuleValidator.MAX_AGE_LOWER_LIMIT, RetentionRuleValidator.MAX_AGE_UPPER_LIMIT));
        }
        if (!RetentionRuleValidator.isValidAgeUnit(this.deletedAgeUnit, this.maxDeletedAge).booleanValue()) {
            validations.add("deletedAgeUnit of DAY, MONTH or YEAR should be provided when maxDeletedAge specified");
        }
        if (this.getKeepAll() && this.getMaxDeletedAge() != null) {
            validations.add("maxDeletedAge should be null when keepAll is true");
        }
        return validations;
    }

    public OffsetDateTime calculateMaxDate(OffsetDateTime now) {
        return now.minus(this.maxDeletedAge.intValue(), ChronoUnit.valueOf(this.deletedAgeUnit.name()));
    }

    public static TrashRetentionRuleBuilder builder() {
        return new TrashRetentionRuleBuilder();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TrashRetentionRule)) {
            return false;
        }
        TrashRetentionRule TrashRetentionRule2 = (TrashRetentionRule)other;
        return Objects.equals(TrashRetentionRule2.maxDeletedAge, this.maxDeletedAge) && Objects.equals(TrashRetentionRule2.deletedAgeUnit, this.deletedAgeUnit) && Objects.equals(TrashRetentionRule2.getKeepAll(), this.keepAll);
    }

    public int hashCode() {
        return Objects.hash(this.maxDeletedAge, this.deletedAgeUnit, this.keepAll);
    }

    public String toString() {
        return "TrashRetentionRule{maxDeletedAge=" + this.maxDeletedAge + ", deletedAgeUnit=" + String.valueOf(this.deletedAgeUnit) + ", keepAll=" + this.keepAll + "}";
    }

    public static class TrashRetentionRuleBuilder {
        private Integer maxDeletedAge;
        private AgeUnit deletedAgeUnit;
        private boolean keepAll;

        public TrashRetentionRuleBuilder maxDeletedAge(Integer maxDeletedAge) {
            this.maxDeletedAge = maxDeletedAge;
            return this;
        }

        public TrashRetentionRuleBuilder deletedAgeUnit(AgeUnit deletedAgeUnit) {
            this.deletedAgeUnit = deletedAgeUnit;
            return this;
        }

        public TrashRetentionRuleBuilder keepAll(boolean keepAll) {
            this.keepAll = keepAll;
            return this;
        }

        public TrashRetentionRule build() {
            return new TrashRetentionRule(this.maxDeletedAge, this.deletedAgeUnit, this.keepAll);
        }
    }
}

