/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeStatus {
    @JsonProperty
    @Schema
    private final int nodeId;
    @JsonProperty
    @JsonDeserialize(as=HashMap.class)
    @Schema
    private final Map<String, String> jvmStats;
    @JsonProperty
    @Schema
    private final Map<String, String> props;
    @JsonProperty
    @Schema
    private final Map<String, String> buildStats;

    @JsonCreator
    public NodeStatus(@JsonProperty(value="nodeId") int nodeId, @JsonProperty(value="jvmStats") Map<String, String> jvmStats, @JsonProperty(value="props") Map<String, String> props, @JsonProperty(value="buildStats") Map<String, String> buildStats) {
        this.nodeId = nodeId;
        this.jvmStats = jvmStats;
        this.props = props;
        this.buildStats = buildStats;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Map<String, String> getJvmStats() {
        return Collections.unmodifiableMap(this.jvmStats);
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.props);
    }

    public Map<String, String> getBuildStats() {
        return Collections.unmodifiableMap(this.buildStats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return this.nodeId == that.nodeId && Objects.equals(this.jvmStats, that.jvmStats) && Objects.equals(this.props, that.props) && Objects.equals(this.buildStats, that.buildStats);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.jvmStats, this.props, this.buildStats);
    }
}

