/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.watch;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.watch.AbstractWatch;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContentWatch
extends AbstractWatch {
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    @Schema
    private final Reference<Content> content;

    @JsonCreator
    public ContentWatch(@JsonProperty(value="watcher") @NonNull User watcher, @JsonProperty(value="contentId") @NonNull ContentId contentId) {
        super(watcher);
        this.content = Reference.orEmpty(Content.builder().id(contentId).build(), Content.class);
    }

    private ContentWatch(ContentWatchBuilder builder) {
        super(builder.watcher);
        this.content = Reference.orEmpty(builder.content, Content.class);
    }

    public Content getContent() {
        return this.content.get();
    }

    @Override
    public String toString() {
        return "ContentWatch{content=" + String.valueOf(this.content) + ", watcher=" + String.valueOf(this.getWatcher()) + "}";
    }

    public static ContentWatchBuilder builder() {
        return new ContentWatchBuilder();
    }

    public static class ContentWatchBuilder {
        private Reference<Content> content;
        private User watcher;

        public ContentWatchBuilder content(Reference<Content> content) {
            this.content = content;
            return this;
        }

        public ContentWatchBuilder watcher(User watcher) {
            this.watcher = watcher;
            return this;
        }

        public ContentWatch build() {
            return new ContentWatch(this);
        }
    }
}

