/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.watch;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.ModelListBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.watch.AbstractWatch;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SpaceWatch
extends AbstractWatch {
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Space.class)
    @JsonProperty
    @Schema
    private final Reference<Space> space;
    @JsonProperty
    @Schema
    private final List<ContentType> contentTypes;

    public SpaceWatch(User watcher, String spaceKey, List<ContentType> contentTypes) {
        super(watcher);
        this.space = Reference.orEmpty(Space.builder().key(spaceKey).build(), Space.class);
        this.contentTypes = contentTypes;
    }

    @JsonCreator
    public SpaceWatch(@JsonProperty(value="watcher") @NonNull User watcher, @JsonProperty(value="space") @NonNull Reference<Space> space, @JsonProperty(value="contentTypes") List<ContentType> contentTypes) {
        super(watcher);
        this.space = space;
        this.contentTypes = contentTypes;
    }

    public SpaceWatch(SpaceWatchBuilder builder) {
        super(builder.watcher);
        this.space = builder.space;
        this.contentTypes = builder.contentTypes.build();
    }

    @Override
    public String toString() {
        return "SpaceWatch{space=" + String.valueOf(this.space) + ", watcher=" + String.valueOf(this.getWatcher()) + "}";
    }

    public Space getSpace() {
        return this.space.get();
    }

    public List<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public static SpaceWatchBuilder builder() {
        return new SpaceWatchBuilder();
    }

    public static class SpaceWatchBuilder {
        private Reference<Space> space;
        private ModelListBuilder<ContentType> contentTypes = ModelListBuilder.newExpandedInstance();
        private User watcher;

        public SpaceWatchBuilder space(Reference<Space> space) {
            this.space = space;
            return this;
        }

        public SpaceWatchBuilder contentList(Iterable<ContentType> contentTypes) {
            this.contentTypes.putAll(contentTypes);
            return this;
        }

        public SpaceWatchBuilder watcher(User watcher) {
            this.watcher = watcher;
            return this;
        }

        public SpaceWatch build() {
            return new SpaceWatch(this);
        }
    }
}

