/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRuleBuilder;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class ImmutableWhitelistRule
implements WhitelistRule,
Serializable {
    private final Integer id;
    private final String expression;
    private final WhitelistType type;
    private final boolean allowInbound;
    private final boolean authenticationRequired;

    public ImmutableWhitelistRule(ImmutableWhitelistRuleBuilder builder) {
        Objects.requireNonNull(builder, "builder");
        this.id = builder.getId();
        this.expression = Objects.requireNonNull(builder.getExpression(), "expression");
        this.type = Objects.requireNonNull(builder.getType(), "type");
        this.allowInbound = builder.isAllowInbound();
        this.authenticationRequired = builder.isAuthenticationRequired();
    }

    public ImmutableWhitelistRule(WhitelistRule copy) {
        Objects.requireNonNull(copy, "copy");
        this.id = copy.getId();
        this.expression = Objects.requireNonNull(copy.getExpression(), "expression");
        this.type = Objects.requireNonNull(copy.getType(), "type");
        this.allowInbound = copy.isAllowInbound();
        this.authenticationRequired = copy.isAuthenticationRequired();
    }

    public static ImmutableWhitelistRuleBuilder builder() {
        return new ImmutableWhitelistRuleBuilder();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public WhitelistType getType() {
        return this.type;
    }

    @Override
    public boolean isAllowInbound() {
        return this.allowInbound;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableWhitelistRule that = (ImmutableWhitelistRule)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.expression, that.expression) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.allowInbound, that.allowInbound) && Objects.equals(this.authenticationRequired, that.authenticationRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.expression, this.type, this.allowInbound, this.authenticationRequired});
    }

    public String toString() {
        return "ImmutableWhitelistRule{id=" + this.id + ", expression='" + this.expression + "', type=" + String.valueOf((Object)this.type) + ", allowInbound=" + this.allowInbound + ", authenticationRequired=" + this.authenticationRequired + "}";
    }
}

