/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.events;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.events.WhitelistRuleEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WhitelistRuleChangedEvent
extends WhitelistRuleEvent {
    @Nullable
    private final WhitelistRule oldRule;

    public WhitelistRuleChangedEvent(@Nonnull WhitelistRule whitelistRule) {
        this(null, whitelistRule);
    }

    public WhitelistRuleChangedEvent(@Nullable WhitelistRule oldRule, @Nonnull WhitelistRule newRule) {
        super(Objects.requireNonNull(newRule));
        this.oldRule = oldRule;
    }

    @Nullable
    public WhitelistRule getOldRule() {
        return this.oldRule;
    }

    public @NonNull WhitelistRule getNewRule() {
        return this.whitelistRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhitelistRuleChangedEvent that = (WhitelistRuleChangedEvent)o;
        return Objects.equals(this.getOldRule(), that.getOldRule()) && Objects.equals(this.getNewRule(), that.getNewRule());
    }

    public int hashCode() {
        return Objects.hash(this.getOldRule(), this.getNewRule());
    }

    public String toString() {
        return "WhitelistRuleChangedEvent{oldRule=" + String.valueOf(this.getOldRule()) + ", newRule=" + String.valueOf(this.getNewRule()) + "}";
    }
}

