/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.components.impl;

import com.atlassian.confluence.plugins.dailysummary.components.SingleUseUnsubscribeTokenManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.security.random.SecureTokenGenerator;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultUnsubscribeTokenManager
implements SingleUseUnsubscribeTokenManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUnsubscribeTokenManager.class);
    static final String USER_HASH_KEY = "confluence.prefs.plugins.dailysummary.unsubscribe.hashkey";
    static final String USER_TOKEN_KEY = "confluence.prefs.plugins.dailysummary.unsubscribe.tokenkey";
    private final UserAccessor userAccessor;
    private final SecureTokenGenerator secureTokenGenerator;

    public DefaultUnsubscribeTokenManager(@ComponentImport UserAccessor userAccessor, @ComponentImport SecureTokenGenerator secureTokenGenerator) {
        this.userAccessor = userAccessor;
        this.secureTokenGenerator = secureTokenGenerator;
    }

    @Override
    public String getUserToken(ConfluenceUser user) {
        try {
            boolean requireNewToken;
            UserPreferences userPrefs = this.userAccessor.getUserPreferences(user);
            String token = userPrefs.getString(USER_TOKEN_KEY).isPresent() ? (String)userPrefs.getString(USER_TOKEN_KEY).get() : null;
            boolean bl = requireNewToken = token == null;
            if (!requireNewToken) {
                String storedHash;
                String hash = this.hashUserDetailsAndToken(user, token);
                boolean bl2 = requireNewToken = !hash.equals(storedHash = (String)userPrefs.getString(USER_HASH_KEY).get());
            }
            if (requireNewToken) {
                return this.generatePublicToken(userPrefs, user);
            }
            return token;
        }
        catch (Exception ex) {
            log.warn(String.format("Could not generate token for user : %s", user.getName()), (Throwable)ex);
            return null;
        }
    }

    private String generatePublicToken(UserPreferences prefs, ConfluenceUser user) throws NoSuchAlgorithmException, UserPreferences.PreferenceException {
        String tokenStr = this.secureTokenGenerator.generateToken();
        prefs.setString(USER_TOKEN_KEY, tokenStr);
        prefs.setString(USER_HASH_KEY, this.hashUserDetailsAndToken(user, tokenStr));
        return tokenStr;
    }

    private String hashUserDetailsAndToken(ConfluenceUser user, String token) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(user.getEmail().getBytes(StandardCharsets.UTF_8));
        md5.update(user.getName().getBytes(StandardCharsets.UTF_8));
        md5.update(token.getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printBase64Binary((byte[])md5.digest());
    }

    @Override
    public boolean isValidToken(ConfluenceUser user, String token) {
        try {
            if (user == null) {
                return false;
            }
            UserPreferences userPrefs = this.userAccessor.getUserPreferences(user);
            if (userPrefs.getString(USER_TOKEN_KEY).isEmpty()) {
                return false;
            }
            String storedToken = (String)userPrefs.getString(USER_TOKEN_KEY).get();
            if (StringUtils.isBlank((CharSequence)token)) {
                return false;
            }
            if (!token.equals(storedToken)) {
                return false;
            }
            if (userPrefs.getString(USER_HASH_KEY).isEmpty()) {
                return false;
            }
            String storedHash = (String)userPrefs.getString(USER_HASH_KEY).get();
            if (StringUtils.isBlank((CharSequence)storedHash)) {
                return false;
            }
            boolean valid = this.hashUserDetailsAndToken(user, token).equals(storedHash);
            this.removeToken(user);
            return valid;
        }
        catch (Exception ex) {
            log.warn(String.format("Exception in validating unsubscribe token: %s, for user: %s", user, token), (Throwable)ex);
            return false;
        }
    }

    private void removeToken(ConfluenceUser user) throws Exception {
        UserPreferences prefs = this.userAccessor.getUserPreferences(user);
        prefs.remove(USER_TOKEN_KEY);
        prefs.remove(USER_HASH_KEY);
    }
}

