/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.content;

import com.atlassian.confluence.content.datasource.DataSource;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SummaryEmailPanelData {
    private final boolean hasContent;
    private final List<DataSource> imageDatasources;

    SummaryEmailPanelData(Builder builder) {
        this.hasContent = builder.hasContent;
        this.imageDatasources = builder.imageDatasources.build();
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public List<DataSource> getImageDatasources() {
        return this.imageDatasources;
    }

    public static Builder builder(String webPanelKey) {
        return new Builder(webPanelKey);
    }

    public static class Builder {
        private boolean hasContent;
        private final ImmutableList.Builder<DataSource> imageDatasources = ImmutableList.builder();

        public SummaryEmailPanelData build() {
            return new SummaryEmailPanelData(this);
        }

        public Builder(String webPanelKey) {
            if (StringUtils.isBlank((CharSequence)webPanelKey)) {
                throw new IllegalArgumentException("Web panel key should not be null for SummaryEmailPanelData");
            }
        }

        public Builder hasContent(boolean hasContent) {
            this.hasContent = hasContent;
            return this;
        }

        public Builder addImageDataSources(Iterable<? extends DataSource> imageDatasources) {
            for (DataSource dataSource : imageDatasources) {
                this.imageDatasources.add((Object)dataSource);
            }
            return this;
        }

        public Builder addImageDataSource(DataSource imageDatasource) {
            this.imageDatasources.add((Object)imageDatasource);
            return this;
        }
    }
}

