/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.content.popular;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PopularContentExcerptDto {
    private final ImmutableMap<String, DataSource> imageDataSources;
    private final ImmutableList<User> networkParticipants;
    private final int commentCount;
    private final int likeCount;
    private final User author;
    private final String excerptHtml;
    private final String contentTitle;
    private final String contentLink;

    private PopularContentExcerptDto(Builder builder) {
        this.imageDataSources = builder.imageDatasources.build();
        this.networkParticipants = builder.networkParticipants.build();
        this.commentCount = builder.commentCount;
        this.likeCount = builder.likeCount;
        this.author = builder.author;
        this.excerptHtml = builder.excerptHtml;
        this.contentTitle = builder.contentTitle;
        this.contentLink = builder.contentLink;
    }

    public Map<String, DataSource> getImageDataSources() {
        return this.imageDataSources;
    }

    public List<User> getNetworkParticipants() {
        return this.networkParticipants;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public int getLikeCount() {
        return this.likeCount;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getExcerptHtml() {
        return this.excerptHtml;
    }

    public String getContentTitle() {
        return this.contentTitle;
    }

    public String getContentLink() {
        return this.contentLink;
    }

    public String toString() {
        return "PopularContentExcerptDto [contentTitle=" + this.contentTitle + ", imageDatasources=" + String.valueOf(this.imageDataSources) + ", networkParticipants=" + String.valueOf(this.networkParticipants) + ", commentCount=" + this.commentCount + ", likeCount=" + this.likeCount + ", author=" + String.valueOf(this.author) + ", excerptHtml=" + this.excerptHtml + ", contentLink=" + this.contentLink + "]";
    }

    public static class Builder {
        public String contentLink;
        private final ImmutableMap.Builder<String, DataSource> imageDatasources = new ImmutableMap.Builder();
        private final ImmutableList.Builder<User> networkParticipants = new ImmutableList.Builder();
        private final int commentCount;
        private int likeCount;
        private final User author;
        private String excerptHtml;
        private final String contentTitle;

        public Builder(ContentEntityObject content, User author) {
            this.contentTitle = content.getDisplayTitle();
            this.commentCount = content instanceof Comment ? ((Comment)content).getChildren().size() : content.getComments().size();
            this.contentLink = content.getUrlPath();
            this.author = author;
        }

        public PopularContentExcerptDto build() {
            return new PopularContentExcerptDto(this);
        }

        public Builder addImageDataSource(Map<String, DataSource> imageDataSource) {
            this.imageDatasources.putAll(imageDataSource);
            return this;
        }

        public Builder addNetworkParticipant(Iterable<User> networkParticipants) {
            this.networkParticipants.addAll(networkParticipants);
            return this;
        }

        public Builder likeCount(int count) {
            this.likeCount = count;
            return this;
        }

        public Builder excerptBody(String excerptBody) {
            this.excerptHtml = excerptBody;
            return this;
        }
    }
}

