/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest.util;

import com.google.common.base.Charsets;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyLoggingFilter
implements ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(JerseyLoggingFilter.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        this.logResponse(requestContext, responseContext);
    }

    private void logResponse(ClientRequestContext cr, ClientResponseContext response) {
        if (log.isDebugEnabled() && response.getEntityStream() != null) {
            try (InputStream inputStream = response.getEntityStream();){
                byte[] entity = IOUtils.toByteArray((InputStream)inputStream);
                String entityAsString = new String(entity, Charsets.UTF_8);
                log.debug("Request URI {}, Response body: {}", (Object)cr.getUri(), (Object)entityAsString);
                response.setEntityStream((InputStream)new ByteArrayInputStream(entity));
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
    }
}

