/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.azure.AzureFilteringEnabledChecker;
import com.atlassian.crowd.common.properties.BooleanSystemProperty;
import com.atlassian.crowd.embedded.spi.DcLicenseChecker;
import com.atlassian.crowd.exception.FeatureInaccessibleException;

public class AzureFilteringEnabledCheckerImpl
implements AzureFilteringEnabledChecker {
    private final DcLicenseChecker dcLicenseChecker;
    private static final BooleanSystemProperty CROWD_AZURE_FILTERING_DISABLE_FLAG = new BooleanSystemProperty("crowd.azure.filtering.disable", false);

    public AzureFilteringEnabledCheckerImpl(DcLicenseChecker dcLicenseChecker) {
        this.dcLicenseChecker = dcLicenseChecker;
    }

    public boolean isAccessible() {
        return this.dcLicenseChecker.isDcLicense();
    }

    public void throwIfFeatureDisabledOrInaccessible() {
        if (!this.isAccessible()) {
            throw new FeatureInaccessibleException("Feature requires Data Center License");
        }
    }

    public boolean isEnabled() {
        return (Boolean)CROWD_AZURE_FILTERING_DISABLE_FLAG.getValue() == false && this.isAccessible();
    }
}

