/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.rest;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugins.highlight.SelectionModificationException;
import com.atlassian.confluence.plugins.highlight.SelectionStorageFormatModifier;
import com.atlassian.confluence.plugins.highlight.model.TableModification;
import com.atlassian.confluence.plugins.highlight.model.TextSearch;
import com.atlassian.confluence.plugins.highlight.model.XMLModification;
import com.atlassian.confluence.plugins.highlight.rest.TableModificationBean;
import com.atlassian.confluence.plugins.highlight.rest.WebItemModuleDescriptorEntity;
import com.atlassian.confluence.plugins.highlight.rest.XMLModificationBean;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Path(value="/")
public class SelectionModificationResource {
    private static final Logger log = LoggerFactory.getLogger(SelectionModificationResource.class);
    private final SelectionStorageFormatModifier formatFinder;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final PageManager pageManager;

    @Inject
    public SelectionModificationResource(SelectionStorageFormatModifier formatFinder, @ComponentImport DynamicWebInterfaceManager webInterfaceManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport PageManager pageManager) {
        this.formatFinder = formatFinder;
        this.webInterfaceManager = webInterfaceManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.pageManager = pageManager;
    }

    @GET
    @Path(value="panel-items")
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    public Response panelItems(@QueryParam(value="pageId") @DefaultValue(value="0") long pageId) {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        DefaultWebInterfaceContext context = this.getContext(pageId);
        List displayableItems = this.webInterfaceManager.getDisplayableItems("page.view.selection/action-panel", context.toMap());
        ArrayList<WebItemModuleDescriptorEntity> entities = new ArrayList<WebItemModuleDescriptorEntity>();
        for (WebItemModuleDescriptor displayableItem : displayableItems) {
            if (displayableItem instanceof com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor) {
                com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor deprecatedDescriptor = (com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor)displayableItem;
                entities.add(new WebItemModuleDescriptorEntity(deprecatedDescriptor, i18NBean));
                continue;
            }
            log.error("DisplayableItem {} is not of type {}", (Object)displayableItem, (Object)com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor.class.getName());
        }
        return Response.ok(entities).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="insert-storage-fragment")
    public Response insertStorageFragment(XMLModificationBean modificationBean) throws SAXException {
        try {
            long pageId = modificationBean.getPageId();
            long lastFetchTime = modificationBean.getLastFetchTime();
            TextSearch selection = new TextSearch(modificationBean.getSelectedText(), modificationBean.getNumMatches(), modificationBean.getIndex());
            XMLModification xmlModification = modificationBean.getXmlModification();
            boolean inserted = this.formatFinder.appendToSelection(pageId, lastFetchTime, selection, xmlModification);
            return Response.ok((Object)inserted).build();
        }
        catch (SelectionModificationException e) {
            return this.createResponse(e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="insert-storage-column-table")
    public Response insertStorageTableColumnCells(TableModificationBean tableModificationBean) throws SAXException {
        try {
            long pageId = tableModificationBean.getPageId();
            long lastFetchTime = tableModificationBean.getLastFetchTime();
            TextSearch selection = new TextSearch(tableModificationBean.getSelectedText(), tableModificationBean.getNumMatches(), tableModificationBean.getIndex());
            TableModification tableModification = new TableModification(tableModificationBean.getTableColumnIndex(), tableModificationBean.getCellModifications());
            boolean inserted = this.formatFinder.appendToColumnTableCells(pageId, lastFetchTime, selection, tableModification);
            return Response.ok((Object)inserted).build();
        }
        catch (SelectionModificationException e) {
            return this.createResponse(e);
        }
    }

    private Response createResponse(SelectionModificationException e) {
        return Response.status((Response.Status)(switch (e.getType()) {
            case SelectionModificationException.Type.NO_OBJECT_TO_MODIFY -> Response.Status.NOT_FOUND;
            case SelectionModificationException.Type.NO_PERMISSION -> Response.Status.UNAUTHORIZED;
            case SelectionModificationException.Type.STALE_OBJECT_TO_MODIFY -> Response.Status.CONFLICT;
            default -> Response.Status.BAD_REQUEST;
        })).entity((Object)e.getMessage()).build();
    }

    private DefaultWebInterfaceContext getContext(long pageId) {
        DefaultWebInterfaceContext context = new DefaultWebInterfaceContext();
        context.setCurrentUser(AuthenticatedUserThreadLocal.get());
        if (pageId != 0L) {
            AbstractPage page = this.pageManager.getAbstractPage(pageId);
            if (page != null) {
                context.setPage(page);
                context.setSpace(page.getSpace());
            } else {
                log.warn("Could not find page with id : {}, unable to set page in context", (Object)pageId);
            }
        }
        return context;
    }
}

