/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferencesKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HighlightOptionPanelConfigService {
    private static final String USER_HIGHLIGHT_OPTION_PANEL_CONFIG_FIELD = "PROPERTY_USER_HIGHLIGHT_OPTION_PANEL_ENABLED";
    private final UserAccessor userAccessor;

    @Autowired
    public HighlightOptionPanelConfigService(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public boolean isSupported() {
        Class<UserPreferencesKeys> userPreferencesKeysClass = UserPreferencesKeys.class;
        try {
            userPreferencesKeysClass.getDeclaredField(USER_HIGHLIGHT_OPTION_PANEL_CONFIG_FIELD);
            return true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public boolean isEnabled() {
        return this.userAccessor.getUserPreferences(AuthenticatedUserThreadLocal.get()).getBoolean("confluence.user.highlight.option.panel.enabled").orElse(false);
    }
}

