/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.urlreadingconditions;

import com.atlassian.confluence.plugins.highlight.service.HighlightOptionPanelConfigService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;

public class DisplayPanelUrlReadingCondition
implements UrlReadingCondition {
    private static final String QUERY_PARAM = "highlightactions";
    private final HighlightOptionPanelConfigService highlightOptionPanelConfigService;
    private boolean highlightConfigSupported;

    public DisplayPanelUrlReadingCondition(HighlightOptionPanelConfigService highlightOptionPanelConfigService) {
        this.highlightOptionPanelConfigService = highlightOptionPanelConfigService;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
        this.highlightConfigSupported = this.highlightOptionPanelConfigService.isSupported();
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isHighlightActionEnabled()) {
            urlBuilder.addToQueryString(QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.parseBoolean(queryParams.get(QUERY_PARAM));
    }

    private boolean isHighlightActionEnabled() {
        return !this.highlightConfigSupported || this.highlightOptionPanelConfigService.isEnabled();
    }
}

