/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.xml;

import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTracker;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.w3c.dom.Node;

public class AppendStateTracker
implements ModificationStateTracker {
    private static final Set<String> allowedTags = Set.of("root", "div", "p", "span", "strong", "em", "u", "i", "small", "ol", "ul", "li", "table", "tbody", "thead", "tr", "th", "td", "h1", "h2", "h3", "h4", "h5", "h6", "sub", "sup", "blockquote");
    private static final Set<String> allowedAcTags = Set.of("ac:layout-cell", "ac:rich-text-body", "ac:task-body", "ac:inline-comment-marker");
    final Deque<Boolean> normalTags = new ArrayDeque<Boolean>();
    final Deque<Boolean> acTags = new ArrayDeque<Boolean>();

    public AppendStateTracker() {
        this.acTags.push(Boolean.TRUE);
        this.normalTags.push(Boolean.TRUE);
    }

    @Override
    public boolean shouldProcessText(Node node) {
        return node.getNodeType() == 3 && this.acTags.peek() != false;
    }

    private boolean isAcTag(String tagName) {
        return tagName.startsWith("ac:");
    }

    @Override
    public void forward(String tagName) {
        if (this.isAcTag(tagName)) {
            this.acTags.push(allowedAcTags.contains(tagName));
        } else {
            this.normalTags.push(this.normalTags.peek() != false && allowedTags.contains(tagName));
        }
    }

    @Override
    public void back(String tagName) {
        if (this.isAcTag(tagName)) {
            this.acTags.pop();
        } else {
            this.normalTags.pop();
        }
    }

    @Override
    public boolean allowInsertion() {
        return this.acTags.peek() != false && this.normalTags.peek() != false;
    }
}

