/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.xml;

import com.atlassian.confluence.plugins.highlight.xml.MacroStateTracker;
import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTrackerV2;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.w3c.dom.Node;

public class MarkStateTracker
implements ModificationStateTrackerV2 {
    private static final Set<String> allowedTags = Set.of("root", "div", "p", "span", "strong", "em", "u", "i", "small", "ol", "ul", "li", "table", "tbody", "thead", "tr", "th", "td", "h1", "h2", "h3", "h4", "h5", "h6", "sub", "sup", "blockquote", "a", "code", "pre", "big");
    private static final Set<String> allowedAcTags = Set.of("ac:layout-cell", "ac:rich-text-body", "ac:task-body", "ac:inline-comment-marker", "ac:structured-macro", "ac:parameter");
    private static final Set<String> inheritAllowedAcTags = Set.of("ac:link");
    private static final Set<String> textAcTags = Set.of("ac:plain-text-link-body", "ac:plain-text-body", "ac:link-body");
    private final Deque<Boolean> allowed = new ArrayDeque<Boolean>();
    private final Deque<Boolean> text = new ArrayDeque<Boolean>();
    private final MacroStateTracker macroStateTracker;
    private boolean isInheritAllowanceEnable;

    public MarkStateTracker() {
        this.allowed.push(Boolean.TRUE);
        this.text.push(Boolean.TRUE);
        this.macroStateTracker = new MacroStateTracker();
    }

    @Override
    public boolean shouldProcessText(Node node) {
        boolean shouldProcess;
        boolean bl = shouldProcess = (node.getNodeType() == 3 || node.getNodeType() == 4) && this.text.peek() != false;
        shouldProcess = this.isInheritAllowanceEnable ? shouldProcess && !this.allowed.contains(false) : shouldProcess;
        shouldProcess = shouldProcess && this.macroStateTracker.shouldProcessText(node);
        return shouldProcess;
    }

    private boolean isAcTag(String tagName) {
        return tagName.startsWith("ac:");
    }

    @Override
    public void forward(Node node, String tagName) {
        if (inheritAllowedAcTags.contains(tagName)) {
            this.isInheritAllowanceEnable = true;
        }
        this.macroStateTracker.forward(node, tagName);
        if (this.isAcTag(tagName)) {
            this.text.push(textAcTags.contains(tagName) || allowedAcTags.contains(tagName));
        }
        this.allowed.push(allowedTags.contains(tagName) || allowedAcTags.contains(tagName));
    }

    @Override
    public void back(Node node, String tagName) {
        if (inheritAllowedAcTags.contains(tagName)) {
            this.isInheritAllowanceEnable = false;
        }
        this.macroStateTracker.back(node, tagName);
        if (this.isAcTag(tagName)) {
            this.text.pop();
        }
        this.allowed.pop();
    }

    @Override
    public boolean allowInsertion() {
        return this.allowed.peek();
    }
}

