/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.xml;

import com.atlassian.confluence.macro.browser.MacroMetadataManager;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.plugins.highlight.model.TextCollection;
import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTracker;
import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTrackerV2;
import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTrackerV2Adaptor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class TextCollector {
    private static final String AC_MACRO_NAME_ATTRIBUTE = "ac:name";
    private static final String EXCLUDED_MACRO_NAMES_PROPERTY = "excluded.macro.names";
    private static final String INLINE_COMMENT_PROPERTIES_FILE = "inline-comment.properties";
    private final Set<String> EXCLUDED_MACRO_NAMES;
    private final MacroMetadataManager macroMetadataManager;
    private static final Logger log = LoggerFactory.getLogger(TextCollector.class);

    @Autowired
    public TextCollector(@ComponentImport MacroMetadataManager macroMetadataManager) {
        this.macroMetadataManager = macroMetadataManager;
        this.EXCLUDED_MACRO_NAMES = new HashSet<String>();
        this.initializeExcludedMacroNames();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        try (InputStream input = TextCollector.class.getClassLoader().getResourceAsStream(INLINE_COMMENT_PROPERTIES_FILE);){
            if (input == null) {
                log.error("Unable to find file {}", (Object)INLINE_COMMENT_PROPERTIES_FILE);
                Properties properties2 = properties;
                return properties2;
            }
            properties.load(input);
            return properties;
        }
        catch (IOException e) {
            log.error("Failed to load properties file: {}", (Object)INLINE_COMMENT_PROPERTIES_FILE, (Object)e);
        }
        return properties;
    }

    public TextCollection collect(Document document, ModificationStateTracker stateTracker) {
        return this.collectTextRecursively(document.getDocumentElement(), stateTracker, new TextCollection());
    }

    private void initializeExcludedMacroNames() {
        Properties properties = this.loadProperties();
        if (System.getProperty(EXCLUDED_MACRO_NAMES_PROPERTY) != null) {
            this.EXCLUDED_MACRO_NAMES.addAll(Arrays.asList(System.getProperty(EXCLUDED_MACRO_NAMES_PROPERTY).split(",")));
        }
        if (properties.getProperty(EXCLUDED_MACRO_NAMES_PROPERTY) != null) {
            this.EXCLUDED_MACRO_NAMES.addAll(Arrays.asList(properties.getProperty(EXCLUDED_MACRO_NAMES_PROPERTY).split(",")));
        }
    }

    private TextCollection collectTextRecursively(Node node, ModificationStateTracker stateTracker, TextCollection textCollection) {
        ModificationStateTrackerV2 stateTrackerV2;
        ModificationStateTrackerV2 modificationStateTrackerV2 = stateTrackerV2 = stateTracker instanceof ModificationStateTrackerV2 ? (ModificationStateTrackerV2)stateTracker : new ModificationStateTrackerV2Adaptor(stateTracker);
        if (node.getNodeType() == 1 && node.hasChildNodes() && this.isMacroCommentable(node)) {
            String tagName = ((Element)node).getTagName();
            stateTrackerV2.forward(node, tagName);
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.collectTextRecursively(childNodes.item(i), stateTrackerV2, textCollection);
            }
            stateTrackerV2.back(node, tagName);
        }
        if (stateTrackerV2.shouldProcessText(node)) {
            textCollection.add(node, stateTrackerV2.allowInsertion());
        }
        return textCollection;
    }

    private boolean isMacroCommentable(Node node) {
        return !this.isMacroExcludedInSystemProperties(node) && this.isMacroCommentableInMacroMetadata(node);
    }

    private boolean isMacroExcludedInSystemProperties(Node node) {
        String macroName = this.getMacroName(node);
        return macroName != null && this.EXCLUDED_MACRO_NAMES.contains(macroName);
    }

    private String getMacroName(Node node) {
        if (node.getAttributes() != null && node.getAttributes().getNamedItem(AC_MACRO_NAME_ATTRIBUTE) != null) {
            return node.getAttributes().getNamedItem(AC_MACRO_NAME_ATTRIBUTE).getNodeValue();
        }
        return null;
    }

    private boolean isMacroCommentableInMacroMetadata(Node node) {
        String macroName = this.getMacroName(node);
        if (macroName == null) {
            return true;
        }
        MacroMetadata macroMetadata = this.macroMetadataManager.getMacroMetadataByName(macroName);
        return macroMetadata == null || macroMetadata.getFormDetails() == null || macroMetadata.getFormDetails().isCommentable();
    }
}

