/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.webhooks;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhooksConfiguration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="webhooksConfiguration")
@ExportAsService(value={WebhooksConfiguration.class})
public class ApplicationWebhooksConfiguration
implements WebhooksConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationWebhooksConfiguration.class);
    private final boolean isWebhooksAllowAllHosts = Boolean.parseBoolean(System.getProperty("confluence.webhooks.allow.all.hosts", "false"));
    @VisibleForTesting
    protected static final String LOCALHOST_CIDR = "127.0.0.1/8";
    @VisibleForTesting
    protected static final String AWS_MAGIC_IP_CIDR = "169.254.0.0/16";

    public boolean isStatisticsEnabled() {
        return true;
    }

    public boolean isInvocationHistoryEnabled() {
        return true;
    }

    public List<String> getBlacklistedAddresses() {
        if (!this.isWebhooksAllowAllHosts) {
            log.info("Allow all hosts is disabled. Returning default blacklisted addresses: {}, {}", (Object)LOCALHOST_CIDR, (Object)AWS_MAGIC_IP_CIDR);
            return List.of(LOCALHOST_CIDR, AWS_MAGIC_IP_CIDR);
        }
        return List.of();
    }
}

