/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.webhooks;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousSiteAccess
public class ApplicationWebhooksPermissionHelperServlet
extends HttpServlet {
    private static final String RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-webhooks:admin-webhooks-soy-resources";
    private static final String TEMPLATE_KEY = "confluence.webhooks.root";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PermissionEnforcer permissionEnforcer;

    @Autowired
    public ApplicationWebhooksPermissionHelperServlet(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport PermissionEnforcer permissionEnforcer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.permissionEnforcer = permissionEnforcer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.permissionEnforcer.isAdmin()) {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, new HashMap());
        } else {
            if (this.permissionEnforcer.isAuthenticated()) {
                throw new AuthorisationException();
            }
            response.sendRedirect(SeraphUtils.getLoginURL((HttpServletRequest)request));
        }
    }
}

