/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailtopage.notifications;

import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugins.emailtopage.events.EmailThreadStagedPayload;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DefaultEmailThreadStagedRenderContextFactory
extends RenderContextProviderTemplate<EmailThreadStagedPayload> {
    private static final String CONFIRM_URL = "/email-to-page/confirm.action?hash=";
    private static final String REJECT_URL = "/email-to-page/reject.action?hash=";
    private final I18NBeanFactory i18NBeanFactory;
    private final GlobalSettingsManager settingsManager;

    public DefaultEmailThreadStagedRenderContextFactory(I18NBeanFactory i18NBeanFactory, GlobalSettingsManager settingsManager) {
        super(EmailThreadStagedPayload.class);
        this.i18NBeanFactory = i18NBeanFactory;
        this.settingsManager = settingsManager;
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<EmailThreadStagedPayload> notification, ServerConfiguration serverConfiguration, RoleRecipient roleRecipient) {
        return Optional.empty();
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<EmailThreadStagedPayload> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        EmailThreadStagedPayload payload = (EmailThreadStagedPayload)notification.getPayload();
        HashMap context = Maps.newHashMapWithExpectedSize((int)6);
        String emailSubject = this.i18NBeanFactory.getI18NBean().getText("email.to.page.name.confirmation.emailsubject", (Object[])new String[]{this.settingsManager.getGlobalSettings().getSiteTitle()});
        String emailSubjectTitle = payload.isError() ? this.i18NBeanFactory.getI18NBean().getText("email.to.page.name.confirmation.emailsubjecttitle.nospace") : this.i18NBeanFactory.getI18NBean().getText("email.to.page.name.confirmation.emailsubjecttitle");
        context.put("subject", emailSubject);
        context.put("subjectTitle", emailSubjectTitle);
        context.put("error", payload.isError());
        context.put("pageTitle", payload.getPageTitle());
        context.put("confirmLink", this.settingsManager.getGlobalSettings().getBaseUrl() + CONFIRM_URL + payload.getHash());
        context.put("rejectLink", this.settingsManager.getGlobalSettings().getBaseUrl() + REJECT_URL + payload.getHash());
        return Optional.of(context);
    }
}

