/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.audit.query;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEventSource;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.query.AuditLogChangesetProjection;
import com.atlassian.crowd.audit.query.AuditLogQuery;
import com.atlassian.crowd.audit.query.AuditLogQueryAuthorRestriction;
import com.atlassian.crowd.audit.query.AuditLogQueryEntityRestriction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ExperimentalApi
public class AuditLogQueryBuilder<T> {
    Class<T> resultClass;
    Instant beforeOrOn;
    Instant onOrAfter;
    List<AuditLogEventType> actions = new ArrayList<AuditLogEventType>();
    List<AuditLogEventSource> sources = new ArrayList<AuditLogEventSource>();
    List<AuditLogQueryAuthorRestriction> authors = new ArrayList<AuditLogQueryAuthorRestriction>();
    List<AuditLogQueryEntityRestriction> users = new ArrayList<AuditLogQueryEntityRestriction>();
    List<AuditLogQueryEntityRestriction> groups = new ArrayList<AuditLogQueryEntityRestriction>();
    List<AuditLogQueryEntityRestriction> applications = new ArrayList<AuditLogQueryEntityRestriction>();
    List<AuditLogQueryEntityRestriction> directories = new ArrayList<AuditLogQueryEntityRestriction>();
    AuditLogChangesetProjection projection;
    int startIndex;
    int maxResults = 1000;

    public static AuditLogQueryBuilder<AuditLogChangeset> changesetQuery() {
        return AuditLogQueryBuilder.queryFor(AuditLogChangeset.class);
    }

    public static <T> AuditLogQueryBuilder<T> queryFor(Class<T> result) {
        return new AuditLogQueryBuilder<T>(result);
    }

    private AuditLogQueryBuilder(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public AuditLogQueryBuilder<T> setBeforeOrOn(Instant beforeOrOn) {
        this.beforeOrOn = beforeOrOn;
        return this;
    }

    public AuditLogQueryBuilder<T> setOnOrAfter(Instant onOrAfter) {
        this.onOrAfter = onOrAfter;
        return this;
    }

    public AuditLogQueryBuilder<T> addAllActions(Collection<AuditLogEventType> actions) {
        this.actions.addAll(actions);
        return this;
    }

    public AuditLogQueryBuilder<T> addAction(AuditLogEventType action) {
        this.actions.add(action);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllSources(Collection<AuditLogEventSource> sources) {
        this.sources.addAll(sources);
        return this;
    }

    public AuditLogQueryBuilder<T> addSource(AuditLogEventSource source) {
        this.sources.add(source);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllAuthors(Collection<AuditLogQueryAuthorRestriction> authors) {
        this.authors.addAll(authors);
        return this;
    }

    public AuditLogQueryBuilder<T> addAuthor(AuditLogQueryAuthorRestriction authors) {
        this.authors.add(authors);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllUsers(Collection<AuditLogQueryEntityRestriction> user) {
        this.users.addAll(user);
        return this;
    }

    public AuditLogQueryBuilder<T> addUser(AuditLogQueryEntityRestriction user) {
        this.users.add(user);
        return this;
    }

    public AuditLogQueryBuilder<T> setUsers(Collection<AuditLogQueryEntityRestriction> users) {
        this.users = new ArrayList<AuditLogQueryEntityRestriction>(users);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllGroups(Collection<AuditLogQueryEntityRestriction> groups) {
        this.groups.addAll(groups);
        return this;
    }

    public AuditLogQueryBuilder<T> addGroup(AuditLogQueryEntityRestriction group) {
        this.groups.add(group);
        return this;
    }

    public AuditLogQueryBuilder<T> setGroups(Collection<AuditLogQueryEntityRestriction> groups) {
        this.groups = new ArrayList<AuditLogQueryEntityRestriction>(groups);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllApplications(Collection<AuditLogQueryEntityRestriction> applications) {
        this.applications.addAll(applications);
        return this;
    }

    public AuditLogQueryBuilder<T> addApplication(AuditLogQueryEntityRestriction application) {
        this.applications.add(application);
        return this;
    }

    public AuditLogQueryBuilder<T> setApplications(Collection<AuditLogQueryEntityRestriction> applications) {
        this.applications = new ArrayList<AuditLogQueryEntityRestriction>(applications);
        return this;
    }

    public AuditLogQueryBuilder<T> addAllDirectories(Collection<AuditLogQueryEntityRestriction> directories) {
        this.directories.addAll(directories);
        return this;
    }

    public AuditLogQueryBuilder<T> addDirectory(AuditLogQueryEntityRestriction directory) {
        this.directories.add(directory);
        return this;
    }

    public AuditLogQueryBuilder<T> setDirectories(Collection<AuditLogQueryEntityRestriction> directories) {
        this.directories = new ArrayList<AuditLogQueryEntityRestriction>(directories);
        return this;
    }

    public AuditLogQueryBuilder<T> setProjection(AuditLogChangesetProjection projection) {
        if (this.projection != null) {
            throw new IllegalStateException("Query projection already set to " + String.valueOf((Object)this.projection));
        }
        this.projection = projection;
        return this;
    }

    public AuditLogQueryBuilder<T> setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public AuditLogQueryBuilder<T> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public AuditLogQuery<T> build() {
        return new AuditLogQuery(this);
    }
}

