/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.avatar;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

public interface AvatarReference {
    public URI toUri();

    public static class BlobAvatar
    implements AvatarReference {
        private final String contentType;
        private final byte[] content;

        public BlobAvatar(String contentType, byte[] content) {
            this.contentType = Objects.requireNonNull(contentType);
            this.content = Objects.requireNonNull(content);
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContent() {
            return this.content;
        }

        @Override
        public URI toUri() {
            return URI.create("data:" + this.getContentType() + ";base64," + Base64.encodeBase64String((byte[])this.getContent()));
        }
    }

    public static class UriAvatarReference
    implements AvatarReference {
        private final URI uri;

        public UriAvatarReference(URI uri) {
            this.uri = Objects.requireNonNull(uri);
        }

        public URI getUri() {
            return this.uri;
        }

        @Override
        public URI toUri() {
            return this.uri;
        }
    }
}

