/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import java.util.Optional;
import java.util.stream.Stream;

public enum SynchronisationStatusKey {
    STARTED("directory.caching.sync.started"),
    INCREMENTAL("directory.caching.sync.incremental"),
    FULL("directory.caching.sync.full"),
    ADDING_USERS("directory.caching.sync.adding.users"),
    UPDATING_USERS("directory.caching.sync.updating.users"),
    DELETING_USERS("directory.caching.sync.deleting.users"),
    USER_MEMBERSHIPS("directory.caching.sync.user.memberships"),
    ADDING_GROUPS("directory.caching.sync.adding.groups"),
    UPDATING_GROUPS("directory.caching.sync.updating.groups"),
    DELETING_GROUPS("directory.caching.sync.deleting.groups"),
    GROUP_MEMBERSHIPS("directory.caching.sync.group.memberships"),
    SUCCESS_INCREMENTAL("directory.caching.sync.completed.INCREMENTAL"),
    SUCCESS_FULL("directory.caching.sync.completed.FULL"),
    FAILURE("directory.caching.sync.completed.error"),
    ABORTED("directory.caching.sync.completed.aborted");

    private final String i18Key;

    private SynchronisationStatusKey(String i18Key) {
        this.i18Key = i18Key;
    }

    public static Optional<SynchronisationStatusKey> fromKey(String key) {
        return Stream.of(SynchronisationStatusKey.values()).filter(k -> k.getI18Key().equals(key)).findFirst();
    }

    public String getI18Key() {
        return this.i18Key;
    }

    public boolean isFinal() {
        return SUCCESS_INCREMENTAL.equals((Object)this) || SUCCESS_FULL.equals((Object)this) || FAILURE.equals((Object)this) || ABORTED.equals((Object)this);
    }
}

