/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.macro;

import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.contributors.analytics.ContributorsMacroMetricsEvent;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.contributors.search.Doc;
import com.atlassian.confluence.contributors.search.PageSearcher;
import com.atlassian.confluence.contributors.util.AuthorRanking;
import com.atlassian.confluence.contributors.util.AuthorRankingSystem;
import com.atlassian.confluence.contributors.util.DefaultPageProcessor;
import com.atlassian.confluence.contributors.util.PageProcessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContributorsMacroHelper {
    private final PageProcessor pageProcessor;
    private final PageSearcher pageSearcher;
    private final DateFormatService dateFormatService;

    @Autowired
    public ContributorsMacroHelper(PageProcessor pageProcessor, PageSearcher pageSearcher, @ComponentImport DateFormatService dateFormatService) {
        this.pageProcessor = pageProcessor;
        this.pageSearcher = pageSearcher;
        this.dateFormatService = dateFormatService;
    }

    public Either<String, Map<String, Object>> getAuthorRankingsModel(ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel parameterModel) {
        List<AuthorRanking> authorRankings = this.getAuthorRankings(metrics, parameterModel);
        if (authorRankings.isEmpty()) {
            return Either.left((Object)parameterModel.getNoContributorsErrorMessage());
        }
        return Either.right(this.buildContributorsModel(authorRankings, metrics, parameterModel));
    }

    private List<AuthorRanking> getAuthorRankings(ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel params) {
        metrics.documentFetchStart();
        Iterable<Doc> documents = this.pageSearcher.getDocuments(params);
        metrics.documentFetchFinish(Iterables.size(documents));
        Set<MacroParameterModel.ContributorsMacroInclude> includes = params.getIncludeParams();
        metrics.userFetchStart(includes);
        AuthorRankingSystem rankingSystem = this.pageProcessor.process(documents, params.getRankType(AuthorRankingSystem.RankType.TOTAL_COUNT), PageProcessor.GroupBy.CONTRIBUTORS, includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.AUTHORS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.COMMENTS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.LABELS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.WATCHES));
        List<AuthorRanking> rankedAuthors = rankingSystem.getRankedAuthors(params.isReverse());
        if (!params.isShowAnonymousContributions()) {
            rankedAuthors.remove(rankingSystem.getAuthorRanking(DefaultPageProcessor.ANONYMOUS_USER.getName()));
        }
        metrics.userFetchFinish(rankedAuthors.size());
        return rankedAuthors;
    }

    private Map<String, Object> buildContributorsModel(List<AuthorRanking> authorRankings, ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel params) {
        List hiddenUsers;
        List visibleUsers;
        metrics.buildTemplateModelStart();
        MacroParameterModel.LayoutStyle layoutStyle = params.getLayoutStyle();
        int limit = params.getLimit();
        if (!MacroParameterModel.isLimitLess(limit) && limit < authorRankings.size()) {
            visibleUsers = Lists.transform(authorRankings.subList(0, limit), x$0 -> new Contributor((AuthorRanking)x$0));
            hiddenUsers = Lists.transform(authorRankings.subList(limit, authorRankings.size()), x$0 -> new Contributor((AuthorRanking)x$0));
        } else {
            visibleUsers = Lists.transform(authorRankings, x$0 -> new Contributor((AuthorRanking)x$0));
            hiddenUsers = Collections.emptyList();
        }
        Map<String, Object> model = Map.of("visibleContributors", visibleUsers, "hiddenContributors", hiddenUsers, "layoutStyle", layoutStyle.name(), "showCount", params.isShowCount(), "showTime", params.isShowTime());
        metrics.buildTemplateModelFinish(layoutStyle);
        return model;
    }

    @JsonAutoDetect
    public class Contributor {
        private final AuthorRanking authorRanking;

        Contributor(AuthorRanking authorRanking) {
            this.authorRanking = authorRanking;
        }

        public String getIdString() {
            return this.authorRanking.getIdString();
        }

        public String getFullNameString() {
            return this.authorRanking.getFullNameString();
        }

        public int getTotalCount() {
            return this.authorRanking.getTotalCount();
        }

        public String getRelativeLastActiveTimeStr() {
            return ContributorsMacroHelper.this.dateFormatService.getFormattedRelativeTime(Instant.ofEpochMilli(this.authorRanking.getLastActiveTime()));
        }
    }
}

