/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.contributors.analytics.ContributorsMacroMetricsEvent;
import com.atlassian.confluence.contributors.macro.ContributorsMacroHelper;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@Path(value="contributors")
public class ContributorsMacroResource {
    private final ContributorsMacroHelper macroHelper;
    private final PageManager pageManager;
    private final EventPublisher eventPublisher;

    @Inject
    public ContributorsMacroResource(ContributorsMacroHelper macroHelper, @ComponentImport PageManager pageManager, @ComponentImport EventPublisher eventPublisher) {
        this.pageManager = pageManager;
        this.eventPublisher = eventPublisher;
        this.macroHelper = macroHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Map<String, Object> getContributors(@Context UriInfo uriInfo, @QueryParam(value="contextEntityId") Long contextEntityId) {
        ContributorsMacroMetricsEvent.Builder dummyMetrics = ContributorsMacroMetricsEvent.builder();
        Either<String, Map<String, Object>> results = this.macroHelper.getAuthorRankingsModel(dummyMetrics, this.parameterModel(uriInfo, contextEntityId));
        this.eventPublisher.publish((Object)dummyMetrics.build());
        if (results.isLeft()) {
            return Collections.singletonMap("errorMessage", results.left().get());
        }
        return (Map)results.right().get();
    }

    private MacroParameterModel parameterModel(@Context UriInfo uriInfo, @QueryParam(value="contextEntityId") Long contextEntityId) {
        Map parameterMap = Maps.transformValues((Map)uriInfo.getQueryParameters(), input -> (String)input.get(0));
        SpaceContentEntityObject contextEntity = (SpaceContentEntityObject)Objects.requireNonNull(this.pageManager.getAbstractPage(contextEntityId.longValue()), "No page found by ID " + contextEntityId);
        return new MacroParameterModel(parameterMap, contextEntity);
    }
}

