/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.search;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.contributors.search.CommentScanner;
import com.atlassian.confluence.contributors.search.Doc;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="commentScanner")
@Internal
class DefaultCommentScanner
implements CommentScanner {
    private final SearchManager searchManager;

    @Autowired
    public DefaultCommentScanner(@ComponentImport SearchManager searchManager) {
        this.searchManager = Objects.requireNonNull(searchManager);
    }

    @Override
    public void scan(Set<Long> pageIds, Consumer<Doc> consumer) {
        if (pageIds.isEmpty()) {
            return;
        }
        SearchQuery searchQuery = this.createQuery(pageIds);
        try {
            this.searchManager.scan(List.of(Index.CONTENT), searchQuery, Doc.REQUESTED_FIELDS, x -> consumer.accept(new Doc(fieldName -> x.getOrDefault(fieldName, new String[0]))));
        }
        catch (InvalidSearchException e) {
            throw new RuntimeException(e);
        }
    }

    private SearchQuery createQuery(Set<Long> pageIds) {
        if (pageIds.isEmpty()) {
            return MatchNoDocsQuery.getInstance();
        }
        Set pageIdStrings = pageIds.stream().map(String::valueOf).collect(Collectors.toSet());
        TermSetQuery subQuery = new TermSetQuery("containingPageId", pageIdStrings);
        return (SearchQuery)BooleanQuery.builder().addMust((Object)new TermQuery(SearchFieldMappings.TYPE.getName(), "comment")).addMust((Object)subQuery).build();
    }
}

