/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.search.extractors;

import com.atlassian.confluence.contributors.search.extractors.AbstractContributionExtractor;
import com.atlassian.confluence.contributors.search.extractors.ContributorsFieldMappings;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={Extractor2.class})
@Component
public class AuthorContributionExtractor
extends AbstractContributionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AuthorContributionExtractor.class);
    private final PageManager pageManager;

    @Autowired
    public AuthorContributionExtractor(@ComponentImport PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        if (!(searchable instanceof AbstractPage)) {
            return null;
        }
        AbstractPage abstractPage = (AbstractPage)searchable;
        List versionHistories = this.pageManager.getVersionHistorySummaries((ContentEntityObject)abstractPage);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (VersionHistorySummary versionHistory : versionHistories) {
            if (versionHistory.getLastModificationDate() == null) {
                logger.warn("Page#{} version#{} has a null last modification date and will be dropped from the content edit contribution calculation.", (Object)abstractPage.getId(), (Object)versionHistory.getVersion());
                continue;
            }
            ConfluenceUser lastModifier = versionHistory.getLastModifier();
            String key = StringEscapeUtils.escapeHtml4(lastModifier == null ? null : lastModifier.getKey().getStringValue());
            long time = versionHistory.getLastModificationDate().getTime();
            String encoded = key + "<>" + time;
            builder.add((Object)ContributorsFieldMappings.AUTHOR_CONTRIBUTIONS.createField(encoded));
        }
        return builder.build();
    }
}

