/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.search.extractors;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.contributors.search.extractors.ContributorsFieldMappings;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.v2.extractor.BulkExtractor;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NotificationContributionBulkExtractor
implements BulkExtractor<Searchable> {
    private final NotificationManager notificationManager;

    public NotificationContributionBulkExtractor(@ComponentImport NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean canHandle(@Nonnull Class<?> type) {
        return Space.class.isAssignableFrom(type) || AbstractPage.class.isAssignableFrom(type);
    }

    public void extractAll(@Nonnull Collection<Searchable> searchables, @Nonnull Class<? extends Searchable> entityType, @Nonnull BiConsumer<Searchable, FieldDescriptor> sink) {
        Map searchableMap = searchables.stream().collect(Collectors.toMap(Searchable::getId, Function.identity()));
        if (Space.class.isAssignableFrom(entityType)) {
            this.notificationManager.getNotificationsBySpacesAndType(this.castSearchables(searchables), null).forEach(notification -> sink.accept((Searchable)searchableMap.get(notification.getSpace().getId()), this.getFieldDescriptor((Notification)notification)));
        } else if (AbstractPage.class.isAssignableFrom(entityType)) {
            this.notificationManager.getNotificationsByContents(this.castSearchables(searchables)).forEach(notification -> sink.accept((Searchable)searchableMap.get(notification.getContent().getId()), this.getFieldDescriptor((Notification)notification)));
        }
    }

    private <T> List<T> castSearchables(Collection<Searchable> searchables) {
        ArrayList result = new ArrayList();
        searchables.forEach(searchable -> result.add(searchable));
        return result;
    }

    private FieldDescriptor getFieldDescriptor(Notification notification) {
        return ContributorsFieldMappings.WATCHERS.createField(notification.getReceiver().getKey().getStringValue());
    }
}

