/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.favicon.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.FilesystemUtils;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.favicon.core.Constants;
import com.atlassian.favicon.core.FaviconManager;
import com.atlassian.favicon.core.ImageType;
import com.atlassian.favicon.core.StoredFavicon;
import com.atlassian.favicon.filter.RequestUtils;
import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class FaviconInterceptor
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(FaviconInterceptor.class);
    private FilterConfig filterConfig;
    private FaviconManager faviconManager;

    public FaviconInterceptor(FaviconManager aFaviconManager) {
        this.faviconManager = aFaviconManager;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            Optional<StoredFavicon> favicon;
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String requestURL = req.getRequestURI().substring(req.getContextPath().length());
            Optional<ImageType> requestedImageType = RequestUtils.getImageTypeFromRequestURL(requestURL);
            if (requestedImageType.isPresent()) {
                ThumbnailDimension requestedDimension = RequestUtils.getDesiredSizeFromRequestURL(requestURL).orElse(Constants.DEFAULT_DIMENSION);
                favicon = this.faviconManager.getFavicon(requestedImageType.get(), requestedDimension);
                if (favicon.isEmpty()) {
                    favicon = this.getDefaultIconFromFile(requestURL, requestedImageType.get());
                }
            } else {
                favicon = this.getDefaultIconFromFile(requestURL, ImageType.ICO);
            }
            if (favicon.isPresent()) {
                this.writeFaviconToResponse(favicon.get(), req, res);
            } else {
                res.setStatus(404);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private Optional<StoredFavicon> getDefaultIconFromFile(String aPath, ImageType anImageType) {
        try {
            if (FilesystemUtils.containsEncodedPathTraversal((String)aPath)) {
                logger.warn("Detected path traversal with a request to a path {}", (Object)aPath);
                return Optional.empty();
            }
            File file = new File(this.filterConfig.getServletContext().getRealPath(RequestUtils.getFilePathWithoutStaticResourcePrefix(aPath)));
            return Optional.of(new StoredFavicon((InputStream)new FileInputStream(file), anImageType.toString(), file.length()));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private void writeFaviconToResponse(StoredFavicon aFavicon, HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        if (aRequest.getServletPath().startsWith("/s/")) {
            ResourceDownloadUtils.addPublicCachingHeaders((HttpServletRequest)aRequest, (HttpServletResponse)aResponse);
        }
        aResponse.setContentLength((int)aFavicon.getContentLength());
        aResponse.setContentType(aFavicon.getContentType());
        try (InputStream imageDataStream = aFavicon.getImageDataStream();
             ServletOutputStream outputStream = aResponse.getOutputStream();){
            IOUtils.copy((InputStream)imageDataStream, (OutputStream)outputStream);
            outputStream.flush();
        }
    }
}

