/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.mywork.host.service.AppLinkHelper;
import com.atlassian.mywork.host.util.HostUtils;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.Task;
import com.atlassian.mywork.service.ActionResult;
import com.atlassian.mywork.service.ActionServiceSelector;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.mywork.service.LocalTaskService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="action")
@Produces(value={"application/json"})
public class ActionResource {
    private static final Logger log = LoggerFactory.getLogger(ActionResource.class);
    private final UserManager userManager;
    private final LocalNotificationService notificationService;
    private final LocalTaskService taskService;
    private final HostApplication hostApplication;
    private final ActionServiceSelector actionService;
    private final ApplicationLinkService applicationLinkService;
    private final AppLinkHelper appLinkHelper;
    private final I18nResolver i18nResolver;
    private final ObjectMapper objectMapper;

    @Inject
    public ActionResource(UserManager userManager, LocalNotificationService notificationService, LocalTaskService taskService, @Named(value="hostApplication") HostApplication hostApplication, ActionServiceSelector actionService, ApplicationLinkService applicationLinkService, AppLinkHelper appLinkHelper, I18nResolver i18nResolver, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.userManager = userManager;
        this.notificationService = notificationService;
        this.taskService = taskService;
        this.hostApplication = hostApplication;
        this.actionService = actionService;
        this.applicationLinkService = applicationLinkService;
        this.appLinkHelper = appLinkHelper;
        this.i18nResolver = i18nResolver;
        this.objectMapper = objectMapperProvider.getObjectMapper();
    }

    @POST
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response execute(JsonNode action) {
        String username = this.userManager.getRemoteUsername();
        long notificationId = action.get("id").longValue();
        Notification notification = this.notificationService.find(username, notificationId);
        return Response.ok((Object)this.send(action, username, notification.getApplicationLinkId())).build();
    }

    @POST
    @Path(value="task")
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response executeTask(JsonNode action) {
        String username = this.userManager.getRemoteUsername();
        Task task = this.taskService.get(action.get("id").longValue());
        return Response.ok((Object)this.send(action, username, task.getApplicationLinkId())).build();
    }

    private ActionResult send(JsonNode action, String username, String applicationLinkId) {
        ActionResult actionResult;
        if (this.hostApplication.getId().get().equals(applicationLinkId) || StringUtils.isEmpty((CharSequence)applicationLinkId)) {
            actionResult = this.actionService.get(action.get("application").textValue()).execute(username, action);
        } else {
            ApplicationLink applicationLink = this.findApplicationLink(applicationLinkId);
            if (applicationLink == null) {
                return InternalFailedActionResult.failure(this.i18nResolver.getText("com.atlassian.mywork.action.no.applink"));
            }
            try {
                actionResult = (ActionResult)this.appLinkHelper.execute(username, applicationLink, "/rest/mywork-client/1/action", (Function<ApplicationLinkRequest, ApplicationLinkRequest>)((Function)appLinkReq -> (ApplicationLinkRequest)((ApplicationLinkRequest)((ApplicationLinkRequest)appLinkReq.setRequestBody(action.toString())).setHeader("Content-Type", "application/json")).setHeader("X-Atlassian-Token", "no-check")), response -> {
                    try {
                        if (response.isSuccessful()) {
                            return (ActionResult)this.objectMapper.readValue(response.getResponseBodyAsStream(), ActionResult.class);
                        }
                        log.info("Request failed with status '{}' and response '{}'", (Object)response.getStatusText(), (Object)response.getResponseBodyAsString());
                        return ActionResult.FAILED;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ResponseException e) {
                        log.info("Failed to perform inline action at remote host", (Throwable)e);
                        return ActionResult.FAILED;
                    }
                }, from -> {
                    String appId = applicationLink.getId().get();
                    String url = this.hostApplication.getBaseUrl().toString() + "/plugins/servlet/mwauthredirect?target=" + HostUtils.urlEncode(appId);
                    return InternalFailedActionResult.oauthFailure(from.getAuthorisationURI(URI.create(url)).toASCIIString());
                });
            }
            catch (ResponseException e) {
                log.info("Failed to perform inline action at remote host", (Throwable)e);
                actionResult = ActionResult.FAILED;
            }
        }
        return actionResult;
    }

    private ApplicationLink findApplicationLink(String applicationLinkId) {
        try {
            return this.applicationLinkService.getApplicationLink(new ApplicationId(applicationLinkId));
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(e);
        }
    }

    public static class InternalFailedActionResult
    extends ActionResult {
        private final String authUrl;
        private final String message;

        private InternalFailedActionResult(String authUrl, String message) {
            super(false, null, null);
            this.authUrl = authUrl;
            this.message = message;
        }

        @JsonProperty
        public String getAuthUrl() {
            return this.authUrl;
        }

        @JsonProperty
        public String getMessage() {
            return this.message;
        }

        public static InternalFailedActionResult oauthFailure(String authUrl) {
            return new InternalFailedActionResult(authUrl, null);
        }

        public static InternalFailedActionResult failure(String message) {
            return new InternalFailedActionResult(null, message);
        }
    }
}

