/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.mywork.host.service.LocalClientService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="client")
@Produces(value={"application/json"})
public class ClientResource {
    private static final Logger log = LoggerFactory.getLogger(ClientResource.class);
    private final LocalClientService clientService;
    private final UserManager userManager;

    @Inject
    public ClientResource(LocalClientService clientService, UserManager userManager) {
        this.clientService = clientService;
        this.userManager = userManager;
    }

    @POST
    @Consumes(value={"text/plain"})
    @UnrestrictedAccess
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response clientRegistration(String appId) {
        log.debug("Updating registration [{}]", (Object)appId);
        this.clientService.updatePotentialClient(appId);
        log.debug("Successfully updated registration [{}]", (Object)appId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="pong")
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response clientPong(@QueryParam(value="appId") String appId) {
        this.clientService.clientPong(this.userManager.getRemoteUsername(), appId);
        return Response.noContent().build();
    }
}

