/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.mywork.host.service.LocalRegistrationService;
import com.atlassian.mywork.model.Registration;
import com.atlassian.mywork.rest.JsonConfig;
import com.atlassian.mywork.rest.MyWorkCacheControl;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import com.atlassian.sal.api.message.LocaleResolver;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Path(value="configuration")
@Produces(value={"application/json"})
@UnlicensedSiteAccess
public class ConfigurationResource {
    private final LocalRegistrationService registrationService;
    private final LocaleResolver localeResolver;
    private final HttpContext httpContext;

    @Inject
    public ConfigurationResource(LocalRegistrationService registrationService, LocaleResolver localeResolver, HttpContext httpContext) {
        this.registrationService = registrationService;
        this.localeResolver = localeResolver;
        this.httpContext = httpContext;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getConfiguration() {
        Option<Pair<List<Registration>, Date>> all = this.registrationService.getAll(new Date(this.httpContext.getActiveRequest().getDateHeader("If-Modified-Since")));
        if (all.isEmpty()) {
            return Response.notModified().build();
        }
        List registrations = (List)((Pair)all.get()).left();
        ArrayList configs = Lists.newArrayListWithExpectedSize((int)registrations.size());
        for (Registration registration : registrations) {
            configs.add(this.createConfig(registration));
        }
        return Response.ok((Object)configs).cacheControl(MyWorkCacheControl.forever()).build();
    }

    private JsonConfig createConfig(Registration registration) {
        return new JsonConfig(registration, this.localeResolver.getLocale());
    }
}

