/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="loggedInUser")
@Produces(value={"application/json"})
public class LoggedInUserResource {
    private final UserManager userManager;

    @Inject
    public LoggedInUserResource(UserManager userManager) {
        this.userManager = userManager;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getUsername() {
        String username = this.userManager.getRemoteUsername();
        if (username == null) {
            username = "";
        }
        return Response.ok((Object)ImmutableMap.of((Object)"username", (Object)username)).build();
    }
}

