/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.mywork.host.notification.AggregationUtil;
import com.atlassian.mywork.host.service.LocalClientService;
import com.atlassian.mywork.host.service.NotificationRendererService;
import com.atlassian.mywork.host.service.UserService;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.Status;
import com.atlassian.mywork.model.Task;
import com.atlassian.mywork.model.UpdateMetadata;
import com.atlassian.mywork.rest.JsonGroupNotification;
import com.atlassian.mywork.rest.JsonNotificationGroup;
import com.atlassian.mywork.rest.MyWorkCacheControl;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@UnlicensedSiteAccess
@Path(value="notification")
@Produces(value={"application/json"})
public class NotificationResource {
    private static final int DEFAULT_LIMIT = 20;
    private final LocalClientService clientService;
    private final LocalNotificationService notificationService;
    private final NotificationRendererService notificationRendererService;
    private final UserManager userManager;
    private final UserService userService;

    @Inject
    public NotificationResource(LocalClientService clientService, LocalNotificationService notificationService, NotificationRendererService notificationRendererService, UserManager userManager, UserService userService) {
        this.clientService = clientService;
        this.notificationService = notificationService;
        this.notificationRendererService = notificationRendererService;
        this.userManager = userManager;
        this.userService = userService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response findByUser(@QueryParam(value="after") long after, @QueryParam(value="before") long before, @QueryParam(value="limit") int limit, @QueryParam(value="bypass") String bypass) {
        String username = this.userService.getBypassUsername(bypass);
        this.clientService.verifyAuth(username);
        return this.notifications(this.findAllAfter(username, after, before, limit));
    }

    private Iterable<Notification> findAllAfter(String username, long after, long before, int limit) {
        return this.notificationService.findAllAfter(username, after, before, limit == 0 ? 20 : limit);
    }

    private Response notifications(Iterable<Notification> notifications) {
        return Response.ok(notifications).cacheControl(MyWorkCacheControl.never()).build();
    }

    @GET
    @Path(value="nested")
    @ScopesAllowed(requiredScope={"READ"})
    public Response findByUserNested(@QueryParam(value="after") long after, @QueryParam(value="before") long before, @QueryParam(value="limit") int limit) {
        String username = this.userManager.getRemoteUsername();
        this.clientService.verifyAuth(username);
        Iterable<Notification> notifications = this.findAllAfter(username, after, before, limit);
        return this.aggregateNotifications(this.notificationRendererService.renderDescriptions(notifications));
    }

    private Response aggregateNotifications(Iterable<Notification> allAfter) {
        ImmutableListMultimap<AggregationUtil.AggregateKey, Notification> aggregate = AggregationUtil.aggregate(allAfter);
        ArrayList json = Lists.newArrayList();
        for (Map.Entry e : aggregate.asMap().entrySet()) {
            Notification notification = (Notification)((Collection)e.getValue()).iterator().next();
            ArrayList notifications = Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Iterable)e.getValue()), from -> new JsonGroupNotification(((AggregationUtil.AggregateKey)e.getKey()).toString(), from)));
            json.add(new JsonNotificationGroup(notification, (List)notifications, ((AggregationUtil.AggregateKey)e.getKey()).toString()));
        }
        return Response.ok((Object)json).cacheControl(MyWorkCacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response findById(@PathParam(value="id") long id) {
        String username = this.userManager.getRemoteUsername();
        return Response.ok((Object)this.notificationService.find(username, id)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createOrUpdate(Notification notification, @QueryParam(value="bypass") String bypass) throws Exception {
        String username = this.userService.getBypassUsername(bypass);
        return Response.ok(this.notificationService.createOrUpdate(username, notification).get()).cacheControl(MyWorkCacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="id") long id) {
        String username = this.userManager.getRemoteUsername();
        this.notificationService.delete(username, id);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="lastreadid")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setLastRead(Long notificationId) {
        String username = this.userManager.getRemoteUsername();
        this.notificationService.setLastRead(username, notificationId);
        return Response.ok().build();
    }

    @PUT
    @Path(value="read")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setRead(List<Long> notificationId) {
        String username = this.userManager.getRemoteUsername();
        this.notificationService.setRead(username, notificationId);
        return Response.ok().build();
    }

    @PUT
    @Path(value="{id}/status")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setStatus(@PathParam(value="id") long id, Status status) {
        String username = this.userManager.getRemoteUsername();
        Task task = this.notificationService.setStatus(username, id, status);
        return Response.ok((Object)task).build();
    }

    @POST
    @Path(value="metadata")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateMetadata(UpdateMetadata metadata) {
        String username = this.userManager.getRemoteUsername();
        this.notificationService.updateMetadata(username, metadata.getGlobalId(), metadata.getCondition(), metadata.getMetadata());
        return Response.noContent().build();
    }
}

