/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.mywork.host.service.UserService;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.rest.JsonCount;
import com.atlassian.mywork.rest.MyWorkCacheControl;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.mywork.service.TimeoutService;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;

@Path(value="status")
@Produces(value={"application/json"})
public class StatusResource {
    private final LocalNotificationService notificationService;
    private final UserService userService;
    private final TimeoutService timeoutService;

    @Inject
    public StatusResource(LocalNotificationService notificationService, UserService userService, TimeoutService timeoutService) {
        this.notificationService = notificationService;
        this.userService = userService;
        this.timeoutService = timeoutService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response get(@QueryParam(value="pageid") Long pageId) {
        return this.getNewNotificationsCountWithTimeout(pageId);
    }

    @GET
    @Path(value="notification/new")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getNewNotificationsCount() {
        return Response.ok((Object)this.getCount()).cacheControl(MyWorkCacheControl.never()).build();
    }

    private int getCount() {
        return this.notificationService.getCount(this.userService.getRemoteUsername());
    }

    private void markNotificationsWithPageIdAsRead(Long pageId) {
        String username = this.userService.getRemoteUsername();
        ArrayList<Long> notificationIdsForCurrentPage = new ArrayList<Long>();
        Iterable unread = this.notificationService.findAllUnread(username, "", "com.atlassian.mywork.providers.confluence");
        for (Notification notification : unread) {
            Long notificationPageId;
            JsonNode metadata = notification.getMetadata().get("pageId");
            if (metadata == null || !pageId.equals(notificationPageId = Long.valueOf(metadata.longValue()))) continue;
            notificationIdsForCurrentPage.add(notification.getId());
        }
        this.notificationService.setRead(username, notificationIdsForCurrentPage);
    }

    @GET
    @Path(value="notification/count")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getNewNotificationsCountWithTimeout(@QueryParam(value="pageid") Long pageId) {
        if (pageId != null) {
            this.markNotificationsWithPageIdAsRead(pageId);
        }
        return Response.ok((Object)new JsonCount(this.getCount(), this.timeoutService.getTimeout(), this.timeoutService.getMaxTimeout())).cacheControl(MyWorkCacheControl.never()).build();
    }
}

