/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.host.event.MyTaskDeprecatedEvent;
import com.atlassian.mywork.host.rest.TaskType;
import com.atlassian.mywork.host.service.UserService;
import com.atlassian.mywork.model.Status;
import com.atlassian.mywork.model.Task;
import com.atlassian.mywork.model.TaskBuilder;
import com.atlassian.mywork.rest.MyWorkCacheControl;
import com.atlassian.mywork.rest.Position;
import com.atlassian.mywork.service.LocalTaskService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@Path(value="task")
@Produces(value={"application/json"})
public class TaskResource {
    private final LocalTaskService taskService;
    private final UserService userManager;
    private final UserAccessor userAccessor;
    private final EventPublisher eventPublisher;
    private final ObjectMapper mapper;

    @Inject
    public TaskResource(LocalTaskService taskService, UserService userManager, UserAccessor userAccessor, EventPublisher eventPublisher, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.taskService = taskService;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.mapper = objectMapperProvider.getObjectMapper();
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response findByUser(@QueryParam(value="type") TaskType type, @QueryParam(value="bypass") String bypass) {
        String username = this.userManager.getBypassUsername(bypass);
        Iterable tasks = type != null ? this.taskService.findAllTasksByType(username, type.entityType) : this.taskService.findAll(username);
        return Response.ok((Object)Lists.newArrayList((Iterable)tasks)).cacheControl(MyWorkCacheControl.never()).build();
    }

    @GET
    @Path(value="count")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getCount(@QueryParam(value="completed") Boolean completed) {
        String username = this.userManager.getRemoteUsername();
        Iterable tasks = this.taskService.findAll(username);
        if (completed != null) {
            int count = 0;
            for (Task task : tasks) {
                if (completed != (task.getStatus() == Status.DONE)) continue;
                ++count;
            }
            return Response.ok((Object)count).cacheControl(MyWorkCacheControl.never()).build();
        }
        return Response.ok((Object)Iterables.size((Iterable)tasks)).cacheControl(MyWorkCacheControl.never()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createOrUpdate(InputStream requestBody, @QueryParam(value="bypass") String bypass) throws Exception {
        String username = this.userManager.getBypassUsername(bypass);
        try {
            JsonNode jsonNode = this.mapper.readTree(requestBody);
            if (jsonNode.isArray()) {
                ArrayList<Task> result = new ArrayList<Task>(jsonNode.size());
                for (JsonNode taskNode : jsonNode) {
                    result.add(this.createOrUpdate(taskNode, username));
                }
                return Response.ok(result).cacheControl(MyWorkCacheControl.never()).build();
            }
            return Response.ok((Object)this.createOrUpdate(jsonNode, username)).cacheControl(MyWorkCacheControl.never()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Task createOrUpdate(JsonNode taskNode, String username) throws Exception {
        Task task = (Task)this.mapper.treeToValue((TreeNode)taskNode, Task.class);
        return (Task)this.taskService.createOrUpdate(username, task).get();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response update(@PathParam(value="id") long id, Task task) {
        String username = this.userManager.getRemoteUsername();
        return Response.ok((Object)this.taskService.update(username, new TaskBuilder(task).id(id).createTask())).cacheControl(MyWorkCacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}/notes")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateNotes(@PathParam(value="id") long id, TextNode jsonNotes) {
        String username = this.userManager.getRemoteUsername();
        String notes = jsonNotes.textValue();
        return Response.ok((Object)this.taskService.updateNotes(username, id, notes).getNotes()).build();
    }

    @DELETE
    @Path(value="{id}")
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="id") long id, @QueryParam(value="bypass") String bypass) {
        String username = this.userManager.getBypassUsername(bypass);
        this.taskService.delete(username, id);
        return Response.ok().cacheControl(MyWorkCacheControl.never()).build();
    }

    @DELETE
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteByGlobalId(@QueryParam(value="bypass") String bypass, @QueryParam(value="globalId") String globalId) {
        String username = this.userManager.getBypassUsername(bypass);
        this.taskService.delete(username, globalId);
        return Response.ok().cacheControl(MyWorkCacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}/position")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response insertBefore(@PathParam(value="id") long id, Position position) {
        String username = this.userManager.getRemoteUsername();
        this.taskService.moveBefore(username, id, position.getBefore());
        return Response.ok().cacheControl(MyWorkCacheControl.never()).build();
    }

    @GET
    @Path(value="globalId/{globalId}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getByGlobalId(@PathParam(value="globalId") String globalId) {
        Task task = this.taskService.find(this.userManager.getRemoteUsername(), globalId);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(MyWorkCacheControl.never()).build();
        }
        return Response.ok((Object)task).cacheControl(MyWorkCacheControl.never()).build();
    }

    @POST
    @Path(value="migrateTasks")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response migrateTasks() {
        UserKey currentUserKey = this.userManager.getRemoteUserKey();
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(currentUserKey);
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        userPreferences.setBoolean("confluence.plugins.myworkday.personaltasks.hasinteracted", true);
        if (userPreferences.getBoolean("confluence.plugins.myworkday.personaltasks.migrated").isPresent() && ((Boolean)userPreferences.getBoolean("confluence.plugins.myworkday.personaltasks.migrated").get()).booleanValue()) {
            return Response.ok().build();
        }
        userPreferences.setBoolean("confluence.plugins.myworkday.personaltasks.migrated", true);
        this.eventPublisher.publish((Object)new MyTaskDeprecatedEvent(currentUserKey));
        return Response.ok().build();
    }

    @POST
    @Path(value="hasInteracted")
    @Consumes(value={"application/json"})
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response hasInteracted() {
        UserKey currentUserKey = this.userManager.getRemoteUserKey();
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(currentUserKey);
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        userPreferences.setBoolean("confluence.plugins.myworkday.personaltasks.hasinteracted", true);
        return Response.ok().build();
    }
}

