/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.mywork.service.TimeoutService;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="timeout")
@Produces(value={"application/json"})
public class TimeoutResource {
    private static final String TIMEOUT = "timeout";
    private static final String MAX_TIMEOUT = "max_timeout";
    private final TimeoutService timeoutService;
    private final UserManager userManager;
    private final HttpContext httpContext;

    @Inject
    public TimeoutResource(TimeoutService timeoutService, UserManager userManager, HttpContext httpContext) {
        this.timeoutService = timeoutService;
        this.userManager = userManager;
        this.httpContext = httpContext;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response get() {
        return Response.ok((Object)ImmutableMap.of((Object)TIMEOUT, (Object)this.timeoutService.getTimeout(), (Object)MAX_TIMEOUT, (Object)this.timeoutService.getMaxTimeout())).build();
    }

    @PUT
    @XsrfProtectionExcluded
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response update() {
        String maxTimeout;
        if (!this.userManager.isAdmin(this.userManager.getRemoteUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String timeout = this.httpContext.getActiveRequest().getParameter(TIMEOUT);
        if (timeout != null) {
            this.timeoutService.setTimeout(Integer.parseInt(timeout));
        }
        if ((maxTimeout = this.httpContext.getActiveRequest().getParameter(MAX_TIMEOUT)) != null) {
            this.timeoutService.setMaxTimeout(Integer.parseInt(maxTimeout));
        }
        return this.get();
    }
}

