/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.service;

import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.mywork.service.XsrfService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

@ExportAsService(value={XsrfService.class})
@Component
public class ConfluenceXsrfService
implements XsrfService {
    private final XsrfTokenService xsrfTokenService;
    private final HttpContext httpContext;

    public ConfluenceXsrfService(@ComponentImport XsrfTokenService xsrfTokenService, @ComponentImport HttpContext httpContext) {
        this.xsrfTokenService = xsrfTokenService;
        this.httpContext = httpContext;
    }

    public String getXsrfParameterName() {
        return "atl_token";
    }

    public String getXsrfToken() {
        return this.xsrfTokenService.generateValidToken(this.httpContext.getActiveRequest());
    }

    public boolean validateFormEncodedToken() {
        return this.xsrfTokenService.hasValidToken(this.httpContext.getActiveRequest());
    }
}

