/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.host.event.RegistrationChangedEvent;
import com.atlassian.mywork.host.service.HTMLServiceImpl;
import com.atlassian.mywork.host.service.LocalRegistrationService;
import com.atlassian.mywork.host.service.NotificationRendererService;
import com.atlassian.mywork.host.soy.GetTextFunction;
import com.atlassian.mywork.host.soy.SoyUtils;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.model.Registration;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.LocaleResolver;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.multibindings.Multibinder;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class NotificationRendererServiceImpl
implements NotificationRendererService,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationRendererServiceImpl.class);
    private final LocalRegistrationService registrationService;
    private final LocaleResolver localeResolver;
    private final HTMLServiceImpl htmlService;
    private final HostApplication hostApplication;
    private final ApplicationLinkService applicationLinkService;
    private final EventPublisher eventPublisher;
    private final LoadingCache<String, Option<SoyTofu>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Option<SoyTofu>>(){

        public Option<SoyTofu> load(String appId) {
            List allRegistrations = (List)((Pair)NotificationRendererServiceImpl.this.registrationService.getAll(new Date(0L)).get()).left();
            Iterable registrations = Iterables.filter((Iterable)allRegistrations, input -> input.getAppId().equals(appId));
            final HashMap<String, Map> i18n = new HashMap<String, Map>();
            ArrayList<String> allTemplates = new ArrayList<String>();
            for (Registration registration : registrations) {
                for (Map.Entry entry : registration.getI18n().entrySet()) {
                    Map l10n = i18n.computeIfAbsent((String)entry.getKey(), k -> new HashMap());
                    l10n.putAll((Map)entry.getValue());
                }
                String templates = registration.getTemplates();
                if (templates == null) continue;
                allTemplates.add(templates);
            }
            if (allTemplates.isEmpty()) {
                return Option.none();
            }
            Injector injector = Guice.createInjector(new AbstractModule(){

                @Override
                protected void configure() {
                    Multibinder<SoyFunction> soyFunctionsSetBinder = Multibinder.newSetBinder(this.binder(), SoyFunction.class);
                    soyFunctionsSetBinder.addBinding().toInstance(new GetTextFunction(NotificationRendererServiceImpl.this.localeResolver, i18n));
                }
            }, new SoyModule());
            SoyFileSet.Builder soyFileSetBuilder = injector.getInstance(SoyFileSet.Builder.class);
            for (String templates : allTemplates) {
                Matcher m = Pattern.compile("\\{namespace(.*?)\\}").matcher(templates);
                Object templateName = "Unknown template";
                if (m.find()) {
                    templateName = m.group(1);
                }
                templateName = (String)templateName + ": UUID[" + String.valueOf(UUID.randomUUID()) + "]";
                soyFileSetBuilder.add(templates, (String)templateName);
            }
            SoyTofu tofu = soyFileSetBuilder.build().compileToTofu();
            return Option.some((Object)tofu);
        }
    });

    public NotificationRendererServiceImpl(LocalRegistrationService registrationService, @ComponentImport LocaleResolver localeResolver, HTMLServiceImpl htmlService, @ComponentImport @Qualifier(value="hostApplication") HostApplication hostApplication, ApplicationLinkService applicationLinkService, EventPublisher eventPublisher) {
        this.registrationService = registrationService;
        this.localeResolver = localeResolver;
        this.htmlService = htmlService;
        this.hostApplication = hostApplication;
        this.applicationLinkService = applicationLinkService;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onRegistrationChangedEvent(RegistrationChangedEvent event) {
        this.cache.invalidate((Object)event.getRegistration().getAppId());
    }

    @EventListener
    public void onRegistrationChangedEvent(ClusterEventWrapper clusterEventWrapper) {
        clusterEventWrapper.unwrapIfType(RegistrationChangedEvent.class).ifPresent(this::onRegistrationChangedEvent);
    }

    @Override
    public Notification renderDescription(Notification notification) {
        return (Notification)Option.option((Object)notification.getApplicationLinkId()).flatMap((java.util.function.Function)((Function)arg_0 -> this.cache.getUnchecked(arg_0))).flatMap((java.util.function.Function)((Function)tofu -> {
            try {
                String description = tofu.newRenderer(this.createDescriptionTemplateName(notification)).setData(this.getData(notification)).render();
                return Option.some((Object)new NotificationBuilder(notification).description(this.htmlService.clean(description)).createNotification());
            }
            catch (SoyTofuException e) {
                LOG.debug(e.getMessage());
                return Option.none();
            }
        })).getOrElse((Object)notification);
    }

    private SoyMapData getData(Notification notification) {
        String description = notification.getDescription();
        return new SoyMapData((Map<String, ?>)ImmutableMap.of((Object)"description", (Object)(description != null ? UnsafeSanitizedContentOrdainer.ordainAsSafe(description, SanitizedContent.ContentKind.HTML) : NullData.INSTANCE), (Object)"metadata", (Object)SoyUtils.toSoyData((JsonNode)notification.getMetadata()), (Object)"baseUrl", (Object)this.getBaseUrl(notification)));
    }

    @Override
    public Iterable<Notification> renderDescriptions(Iterable<Notification> notifications) {
        return Iterables.transform(notifications, this::renderDescription);
    }

    private String createDescriptionTemplateName(Notification notification) {
        String partialName = notification.getEntity() + StringUtils.capitalize((String)notification.getAction()) + "Description";
        return notification.getApplication() + "." + partialName.replaceAll("[^\\w\\d]", "_");
    }

    private String getBaseUrl(Notification notification) {
        if (notification.getApplicationLinkId().isEmpty()) {
            return this.hostApplication.getBaseUrl().toASCIIString();
        }
        try {
            ApplicationId appId = new ApplicationId(notification.getApplicationLinkId());
            return this.applicationLinkService.getApplicationLink(appId).getDisplayUrl().toASCIIString();
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(e);
        }
    }
}

