/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.service;

import java.util.Objects;

public class RequestParameters {
    private static final int DEFAULT_TIMEOUT = 0;
    private final int connectionTimeout;
    private final int soTimeout;

    private RequestParameters(Builder builder) {
        this.connectionTimeout = builder.connectionTimeout;
        this.soTimeout = builder.soTimeout;
    }

    public String toString() {
        return "RequestParameters{connectionTimeout=" + this.connectionTimeout + ", soTimeout=" + this.soTimeout + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestParameters that = (RequestParameters)o;
        return this.connectionTimeout == that.connectionTimeout && this.soTimeout == that.soTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.connectionTimeout, this.soTimeout);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public static class Builder {
        private int connectionTimeout = 0;
        private int soTimeout = 0;

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public RequestParameters build() {
            return new RequestParameters(this);
        }
    }
}

