/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.confluence.dmz.sal.AuthenticationListenerExt;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.mywork.host.util.HostUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class LoginMiniviewServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LoginMiniviewServlet.class);
    private static final String LOGIN_SERVLET = "/plugins/servlet/login-miniview";
    private static final String MINIVIEW_SERVLET = "/plugins/servlet/notifications-miniview";
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final AuthenticationListenerExt authenticationListener;
    private final InternalHostApplication internalHostApplication;
    private final I18nResolver i18nResolver;
    private static final Message AUTH_SUCCESS_MESSAGE = new Message(){

        public Serializable[] getArguments() {
            return null;
        }

        public String getKey() {
            return "com.atlassian.mywork.login.success";
        }
    };
    private static final Message AUTH_FAILURE_MESSAGE = new Message(){

        public Serializable[] getArguments() {
            return null;
        }

        public String getKey() {
            return "com.atlassian.mywork.login.failed";
        }
    };

    public LoginMiniviewServlet(@ComponentImport TemplateRenderer templateRenderer, UserManager userManager, @ComponentImport UserAccessor userAccessor, AuthenticationListenerExt authenticationListener, InternalHostApplication internalHostApplication, I18nResolver i18nResolver) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.authenticationListener = authenticationListener;
        this.internalHostApplication = internalHostApplication;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername();
        if (username == null) {
            this.render(req, resp, (Map<String, Object>)ImmutableMap.of());
        } else {
            resp.sendRedirect(req.getContextPath() + this.getSuccessPath(req));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean authSuccess = this.authenticate(req, resp);
        if (authSuccess) {
            resp.sendRedirect(req.getContextPath() + this.getSuccessPath(req));
        } else {
            this.render(req, resp, (Map<String, Object>)ImmutableMap.of((Object)"error", (Object)this.i18nResolver.getText("com.atlassian.mywork.login.failed.long")));
        }
    }

    public static String getLoginPath(String requestPath) {
        if (requestPath == null) {
            return LOGIN_SERVLET;
        }
        return "/plugins/servlet/login-miniview?os_destination=" + HostUtils.urlEncode(requestPath);
    }

    private String getSuccessPath(HttpServletRequest req) throws ServletException {
        String destination = req.getParameter("os_destination");
        if (destination == null) {
            return MINIVIEW_SERVLET;
        }
        if (destination.startsWith("/")) {
            return destination;
        }
        throw new ServletException("Invalid os_destination: " + destination);
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> extra) throws ServletException, IOException {
        ImmutableMap context = ImmutableMap.builder().putAll(extra).put((Object)"instanceName", (Object)this.internalHostApplication.getName()).put((Object)"baseHref", (Object)this.internalHostApplication.getBaseUrl().toString()).put((Object)"os_destination", (Object)this.getSuccessPath(req)).build();
        resp.setContentType("text/html; charset=UTF-8");
        this.templateRenderer.renderTo((Appendable)resp.getWriter(), "com.atlassian.mywork.mywork-confluence-host-plugin:mw-login-miniview", "MyWork.Templates.Login.main.soy", (Map)context);
    }

    private boolean authenticate(HttpServletRequest req, HttpServletResponse resp) {
        String username = req.getParameter("os_username");
        String password = req.getParameter("os_password");
        boolean authSuccess = false;
        if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
            log.debug("Username or password is blank");
        } else {
            Principal principal = this.userManager.resolve(username);
            if (principal == null) {
                log.debug("User does not exist: {}", (Object)username);
            } else if (this.userAccessor.isDeactivated(username)) {
                log.debug("User is not allowed to log in: {}", (Object)username);
            } else if (this.userManager.authenticate(username, password)) {
                log.debug("User authenticated successfully: {}", (Object)username);
                this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(AUTH_SUCCESS_MESSAGE, principal));
                SeraphUtils.addRememberMeCookie((HttpServletRequest)req, (HttpServletResponse)resp, () -> username);
                authSuccess = true;
            } else {
                log.debug("User attempted to authenticate with incorrect credentials: {}", (Object)username);
                this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(AUTH_FAILURE_MESSAGE));
            }
        }
        return authSuccess;
    }
}

