/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.urlreadingcondition;

import com.atlassian.mywork.service.ServiceSelector;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;

public class HostEnabledUrlReadingCondition
implements UrlReadingCondition {
    private static final String IS_HOST_ENABLED_QUERY_PARAM = "hostenabled";
    private final ServiceSelector serviceSelector;

    public HostEnabledUrlReadingCondition(ServiceSelector serviceSelector) {
        this.serviceSelector = serviceSelector;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isHostEnabled()) {
            urlBuilder.addToQueryString(IS_HOST_ENABLED_QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.parseBoolean(queryParams.get(IS_HOST_ENABLED_QUERY_PARAM));
    }

    private boolean isHostEnabled() {
        return this.serviceSelector.getEffectiveTarget() == ServiceSelector.Target.LOCAL;
    }
}

